/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * GLOBAL HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SRH_HW_H
#define _SRH_HW_H

#ifdef __cplusplus
extern "C" {
#endif


  /**************/
 /** INCLUDES **/
/**************/

  /***************/
 /** CONSTANTS **/
/***************/

// Bosch ID#10: GPIO config for Bosch hardware
#define X65_SHDN_GPIO 119
#define X65_RSTN_GPIO 120

// This NUM shall be equal to the number of controlling GPIOs (above)
#define X65_GPIO_NUM  2

  /**************/
 /** TYPEDEFS **/
/**************/
typedef struct gpio_serial_mapping_struct
{
    // GPIO number
    int iGpio;
    // Corresponding IOCTL attribute
    int un32IoctlAttribute;
    // IOCTL values for low (0) and high (1) states of GPIO accordingly
    int un32IoctlValue[2];
} GPIO_SERIAL_ATTR_MAPPING_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

void SRH_vEnablePower( void );
void SRH_vDisablePower( void );
void SRH_vEnableAntenna( void );
void SRH_vDisableAntenna( void );
void SRH_vEnableReset( void );
void SRH_vDisableReset( void );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/


#ifdef __cplusplus
}
#endif

#endif  // _SRH_HW_H
