/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*DESCRIPTION
*
*       This module will contain the generic BSP functionality
*
*******************************************************************************/

#if !defined(SMS_DEVICE_EMULATION) || (SMS_DEVICE_EMULATION == 0)
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#else
#include "standard.h"
#include "osal.h"
#include "com.h"
#endif

#include "srh_hw.h"

#if (SMS_DEVICE_EMULATION==1)
// Locally global file handle for GPIO
extern FILE *psGPIO;

GPIO_SERIAL_ATTR_MAPPING_STRUCT sGpioMap[X65_GPIO_NUM] =
{
 {X65_SHDN_GPIO, COM_SIGNAL_RTS, {COM_IOCTL_SET_SIGNALS, COM_IOCTL_CLR_SIGNALS}},
 {X65_RSTN_GPIO, COM_SIGNAL_DTR, {COM_IOCTL_SET_SIGNALS, COM_IOCTL_CLR_SIGNALS}}
};
#endif

#if (SMS_DEVICE_EMULATION==1)
/*****************************************************************************
 *
 *       SRH_vSetLineSignal
 *
 *****************************************************************************/
//Bosch ID#28 : Removed Static, to resolve Gen3X86 build error
void SRH_vSetLineSignal(int iGpio, int iValue)
{
    int i;

    for( i = 0; i < X65_GPIO_NUM; i++)
    {
        if( iGpio == sGpioMap[i].iGpio )
        {
            ioctl(
                psGPIO,
                sGpioMap[i].un32IoctlValue[iValue],
                sGpioMap[i].un32IoctlAttribute
                );
            break;
        }
    }

    return;
}
#else
/*****************************************************************************
 *
 *       SRH_vSetLineSignal
 *
 *****************************************************************************/
static void SRH_vSetLineSignal(int iGpio, int iValue)
{
    char acDev[64] = { 0 };
    sprintf(acDev,"/sys/class/gpio/gpio%d/value", iGpio);

    int iHandle = open(acDev, O_RDWR);
    if (iHandle >= 0)
    {
        const char cSigValue = (iValue == 0) ? '0' : '1';
        write(iHandle, &cSigValue, 1);
        close(iHandle);
    }
    return;
}
#endif

/*****************************************************************************
*
*       SRH_vEnablePower
*
*****************************************************************************/
void SRH_vEnablePower( void )
{
    SRH_vSetLineSignal(X65_SHDN_GPIO, 1);
    return;
}

/*****************************************************************************
*
*       SRH_vDisablePower
*
*****************************************************************************/
void SRH_vDisablePower( void )
{
    SRH_vSetLineSignal(X65_SHDN_GPIO, 0);
    return;
}

/*****************************************************************************
*
*       SRH_vEnableAntenna
*
*****************************************************************************/
void SRH_vEnableAntenna( void )
{
    return;
}

/*****************************************************************************
*
*       SRH_vDisableAntenna
*
*****************************************************************************/
void SRH_vDisableAntenna( void )
{
    return;
}

/*****************************************************************************
*
*       SRH_vEnableReset
*
*****************************************************************************/
void SRH_vEnableReset( void )
{
    SRH_vSetLineSignal(X65_RSTN_GPIO, 0);
    return;
}

/*****************************************************************************
*
*       SRH_vDisableReset
*
*****************************************************************************/
void SRH_vDisableReset( void )
{
    SRH_vSetLineSignal(X65_RSTN_GPIO, 1);
    return;
}

