/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
*
*   GLOBAL HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef STANDARD_H_
#define STANDARD_H_

#ifdef __cplusplus
extern "C" {
#endif


  /**************/
 /** INCLUDES **/
/**************/

#include <limits.h>

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/



#if defined( SSPAPI_DLL )

#define EXPORT_TYPE		_declspec(dllexport)
#define	CALL_TYPE		_stdcall

#else

#define EXPORT_TYPE		extern
#define	CALL_TYPE

#endif

#ifndef NULL
	#define NULL        (void *)0
#endif

#define ARM_DEFS 0

/* This macro simplifies testing whether we are using gcc, and if it
   is of a particular minimum version. (Both major & minor numbers are
   significant.)  This macro will evaluate to 0 if we are not using
   gcc at all.  */
#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif /* GCC_VERSION */


#ifdef OS_WINCE
#ifndef BUFSIZ
#define BUFSIZ (1024)
#endif
/* __FUNCTION__ is defined as something useful for CE platforms
   above 1300, like WinCE / PlatformBuilder 5.0. Conditionally
   defining it this way eliminates a warning on those platforms.
   see http://msdn.microsoft.com/en-us/library/aa449711.aspx */
#if _MSC_VER < 1300
#define __FUNCTION__ "Function()"
#endif
#endif

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
#ifdef AVR_DEFS
	typedef unsigned char   	U8;
	typedef unsigned int		U16;
	typedef unsigned long		U32;

	typedef signed char     	N8;
	typedef signed int   		N16;
	typedef signed long     	N32;

	typedef unsigned char   	UN8;
	typedef unsigned int		UN16;
	typedef unsigned long   	UN32;
#endif


#ifdef ARM_DEFS

#define UN8_MIN 	0
#define UN8_MAX		UCHAR_MAX
#define UN16_MIN 	0
#define UN16_MAX	USHRT_MAX
#define UN32_MIN 	0
#define UN32_MAX	ULONG_MAX
#define UN64_MIN 	0
#define UN64_MAX	ULLONG_MAX
#define SIZE_T_MIN  0
#ifndef SIZE_T_MAX
#define SIZE_T_MAX  (size_t)-1
#endif

#define N8_MIN 		SCHAR_MIN
#define N8_MAX		SCHAR_MAX
#define N16_MIN     SHRT_MIN
#define N16_MAX		SHRT_MAX
#define N32_MIN 	LONG_MIN
#define N32_MAX		LONG_MAX
#define N64_MIN 	LLONG_MIN
#define N64_MAX		LLONG_MAX

#define N8_BITLEN      (8*sizeof(N8))
#define N16_BITLEN     (8*sizeof(N16))
#define N32_BITLEN     (8*sizeof(N32))
#define N64_BITLEN     (8*sizeof(N64))
#define UN8_BITLEN     (8*sizeof(UN8))
#define UN16_BITLEN    (8*sizeof(UN16))
#define UN32_BITLEN    (8*sizeof(UN32))
#define UN64_BITLEN    (8*sizeof(UN64))

typedef unsigned char   	U8;
typedef unsigned short		U16;
typedef unsigned int		U32;
#ifdef OS_WINCE
typedef unsigned __int64    U64;
#else
typedef unsigned long long	U64;
#endif

typedef signed char     	N8;
typedef signed short   		N16;
typedef signed int     		N32;
#ifdef OS_WINCE
typedef __int64             N64;
#else
typedef signed long long    N64;
#endif
typedef unsigned char   	UN8;
typedef unsigned short		UN16;
typedef unsigned int   		UN32;
#ifdef OS_WINCE
typedef unsigned __int64    UN64;
#else
typedef unsigned long long  UN64;
#endif

#endif

typedef unsigned char   	BOOLEAN;

#ifdef FALSE
#undef FALSE
#endif
#if defined(__GNUC__) && (GCC_VERSION < 4005)
#define FALSE (0)
#else
#define FALSE ((BOOLEAN)0)
#endif

#ifdef TRUE
#undef TRUE
#endif
#if defined(__GNUC__) && (GCC_VERSION < 4005)
#define TRUE (1)
#else
#define TRUE ((BOOLEAN)1)
#endif

typedef unsigned char   	UCHAR;

#define I8					N8
#define I16					N16
#define I32                 N32
#define I16P 				I16
#define U16P 				U16

// Solution for UNIX Millennium Bug
typedef UN64 TIME_T;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/
#define BYTE0(x)		    (UN8)(x)
#define BYTE1(x)		    (UN8)((x) >> 8)
#define BYTE2(x)		    (UN8)((x) >> 16)
#define BYTE3(x)		    (UN8)((x) >> 24)
#define BYTE4(x)		    (UN8)((x) >> 32)
#define BYTE5(x)		    (UN8)((x) >> 40)
#define BYTE6(x)		    (UN8)((x) >> 48)
#define BYTE7(x)		    (UN8)((x) >> 56)
#define WORD0(x)			(UN16)(x)
#define WORD1(x)			(UN16)((x) >> 16)

#define SWAPUN16(x)     (UN16)( BYTE0(x) << 8 | BYTE1(x) )

#define SWAPUN32(x)     (UN32)( (UN32)(BYTE0((UN32)(x)) << 24) | \
                                (UN32)(BYTE1((UN32)(x)) << 16) | \
                                (UN32)(BYTE2((UN32)(x)) <<  8) | \
                                (UN32)(BYTE3((UN32)(x))      ) )

#define PACKUINT32(b3, b2, b1, b0) \
    (((b3) << 24) | ((b2) << 16) | ((b1) << 8) | (b0))

#ifndef __INLINE__
    #if __ICCARM__ == 1
        #define __INLINE__
    #elif defined __QNX__
        #define __INLINE__ __inline__
	#elif defined _WIN32
		#define __INLINE__
    #elif defined __arm__ && !defined (__GNUC__)
        #define __INLINE__
    #elif defined __GNUC__
        #define __INLINE__ __inline__
    #else
        #error Macro __INLINE__ is not defined!
    #endif
#endif

#ifndef __PACKED__
    #if __ICCARM__ == 1
        #define __PACKED__ _Pragma("pack(1)")
    #elif defined __QNX__
        #define __PACKED__ __attribute__ ((__packed__))
    #elif defined _WIN32
        #define __PACKED__
    #elif defined __arm__ && !defined (__GNUC__)
        #define __PACKED__ __packed
    #elif defined __GNUC__
        #define __PACKED__ __attribute__ ((__packed__))
    #else
        #error Macro __PACKED__ is not defined!
    #endif
#endif

#ifndef __UNPACKED__
    #if __ICCARM__ == 1
        #define __UNPACKED__ _Pragma("pack()")
    #elif defined __QNX__
        #define __UNPACKED__
    #elif defined _WIN32
        #define __UNPACKED__
    #elif defined __arm__ && !defined (__GNUC__)
        #define __UNPACKED__
    #elif defined __GNUC__
        #define __UNPACKED__
    #else
        #error Macro __UNPACKED__ is not defined!
    #endif
#endif

#if __ICCARM__ == 1

    #define print_err(code,text) do { \
    fprintf(stderr, "%s at \"%s\":%d: %d\n", \
        text, __FILE__, __LINE__, code); \
    } while (0)

    #define print_errno(...)

#elif defined __QNX__

    #define print_err(code,text) do { \
    fprintf(stderr, "%s at \"%s\":%d: %s\n", \
        text, __FILE__, __LINE__, strerror (code)); \
    } while (0)

    #define print_errno(text) do { \
    fprintf(stderr, "%s at \"%s\":%d: %s\n", \
        text, __FILE__, __LINE__, strerror (errno)); \
    } while (0)

#elif defined _WIN32

    #define print_err(code,text) do { \
    fprintf(stderr, "%s at \"%s\":%d: %d\n", \
        text, __FILE__, __LINE__, code); \
    } while (0)

#elif defined __arm__ && !defined (__GNUC__)

    #define print_err(code,text) do { \
    fprintf(stderr, "%s at \"%s\":%d: %d\n", \
        text, __FILE__, __LINE__, code); \
    } while (0)

    #define print_errno(...)

#elif defined __GNUC__

   #define print_err(code,text) do { \
   fprintf(stderr, "%s at \"%s\":%d: %s\n", \
       text, __FILE__, __LINE__, strerror (code)); \
   } while (0)

   #define print_errno(text) do { \
   fprintf(stderr, "%s at \"%s\":%d: %s\n", \
       text, __FILE__, __LINE__, strerror (errno)); \
   } while (0)

#else
    #error print_err is not defined!
#endif

// This creates a constant string out of the macro argument provided
#define MACRO_TO_STRING(x)  # x

// This MACRO invokes a compiler-time assertion if the condition is not true
#define COMPILE_TIME_ASSERT(condition, msg) \
    typedef char (msg)[(condition) ? 1 : -1]

struct alignment_struct
{
    UN8 un8Dummy;
    UN32 un32Dummy;
};

#define MACHINE_ALIGNMENT ( sizeof( struct alignment_struct ) / 2 )

#define ALIGN_SIZE(x) \
    { size_t tAlignment = MACHINE_ALIGNMENT; \
        (x) += ( (x) % tAlignment ) ? \
             /* true */ tAlignment - ( (x) % tAlignment ) : /* false */ 0; \
    }

#define SIZEOF(structure,member) ((size_t) sizeof(((structure *)0)->member))

#if _WIN32 && (_MSC_VER < 1900)
// Oddly Visual Studio before 2015 does not support such things which are C-standards
// Guess they are in their own little world.
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#endif

#ifdef OS_WIN32
#undef vsnprintf
#endif

// Compiler specific pragmas

#if __ICCARM__ == 1

// Supress "Warning[Pe186]: pointless comparison of unsigned integer with zero..."
#pragma diag_suppress=Pe186

#endif

// Compares two values and returns:
//   1 - if 'a' greater than 'b'
//   0 - if 'a' equals to 'b'
//  -1 - if 'a' less that 'b'
#define COMPARE(a,b)    ((N16)((a)>(b)? 1 : ((a)<(b)? -1 : 0 )))

// Sets value to the variable if the value within bounds _Min and _Max.
#define SET_VALUE_BOUNDED(_Var, _Val, _Min, _Max, _bIsSet)                 \
{                                                                          \
    (_bIsSet) = (((_Min) <= (_Val)) && ((_Val) <= (_Max))) ? TRUE : FALSE; \
    if ((_bIsSet) == TRUE)                                                 \
    {                                                                      \
        _Var = _Val;                                                       \
    }                                                                      \
}
  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#ifdef __cplusplus
}
#endif

#endif // STANDARD_H_
