/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_wsalerts_messages.h
* @brief       Declaration of the Weather Alert messages for Announcement
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_WSALERTS_MESSAGES_H_
#define FC_SXM_WSALERTS_MESSAGES_H_

#include "fc_sxm_types.h"
#include "fc_sxm_clienthandler_tts_fi.h"

struct fc_sxm_trMsgWsAlertsAudioSource :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 207);
   fc_sxm_trAdressing rAdressing;
   fc_sxm_enAudioSourceActivity enSourceActivity;
};

struct fc_sxm_trMsgTTSClientMResultPrepareVoiceOutput :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 208);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgPrepareVoiceOutputMethodResult oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultFirstSynthesizeSpeak :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 209);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultFirst oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultMiddleSynthesizeSpeak :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 210);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultMiddle oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultLastSynthesizeSpeak :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 211);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgSynthesizeSpeakMethodResultLast oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultAbortPrompt :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 212);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgAbortPromptMethodResult oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultPausePrompt :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 213);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgPausePromptMethodResult oFiMsg;
};

struct fc_sxm_trMsgTTSClientMResultContinuePrompt :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 214);
   fc_sxm_trAdressing rAdressing;
   sds_ttsfi_tclMsgContinuePromptMethodResult oFiMsg;
};

struct fc_sxm_trMsgTTSTimer :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 215);
};

struct fc_sxm_trMsgTTSClientError :
   public fc_sxm_tclMessage
{
   SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 216);
   tU16 u16FID;
   tU16 u16ErrorCode;
};

#endif /* FC_SXM_WSALERTS_MESSAGES_H_ */

