/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_wsalerts_utils.h
* @brief       Declaration of the Util class to find distance information
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*=============================================================================
=======                            DEFINES                              =======
=============================================================================*/
#ifndef _FC_SXM_TCL_WSALERTS_UTILS_H_
#define _FC_SXM_TCL_WSALERTS_UTILS_H_

#include "fc_sxm_types.h"
#include "fc_sxm_wsalerts_fi.h"

//!Return minimum of the two provided values
template<typename T>
const T& ENAVI_MIN(const T &a, const T &b) {return (a<b ? a : b);}

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/


/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/


/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/


/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/


//=====================================================
//!\name    Mathematical Operations
//=====================================================

class fc_sxm_tclWsAlertsUtils {

public:
   fc_sxm_tclWsAlertsUtils(){}

   static tS32 tDoubleS32(tDouble number);
   static tS32 s32RoundVal(tDouble number);

   //Check if the provided position is inside provided polygon
   static tBool bIsPointInsidePolygon(const vector<midw_ext_fi_tcl_PositionWGS84>& vecShapeGeoPoints,
            const midw_ext_fi_tcl_PositionWGS84& rDevLocation);

   static tF32 s32GetDistanceToPolygon(const vector<midw_ext_fi_tcl_PositionWGS84>& vecShapeGeoPoints,
            const midw_ext_fi_tcl_PositionWGS84& oPosition);

   //Calculate the air distance between two positions.
   static tF32 s32GetDistance(const midw_ext_fi_tcl_PositionWGS84& oPosition1,
            const midw_ext_fi_tcl_PositionWGS84& oPosition2);

   // Get the point on line through oPosition1 and oPosition2, which is nearest to oPosition
   static tBool bGetNearestPoint(const midw_ext_fi_tcl_PositionWGS84& oPosition1,
            const midw_ext_fi_tcl_PositionWGS84& oPosition2, const midw_ext_fi_tcl_PositionWGS84& oPosition,
            tBool bLineSegment, midw_ext_fi_tcl_PositionWGS84& oNearestPoint);

   //Calculate the dot product of two vectors: Vector from oPosition1 to oPosition2, and vector from oPosition2 to oPosition3
   static tS32 s32GetDotProduct(const midw_ext_fi_tcl_PositionWGS84& oPosition1,
            const midw_ext_fi_tcl_PositionWGS84& oPosition2, const midw_ext_fi_tcl_PositionWGS84& oPosition3);
};
#endif //_FC_SXM_TCL_WSALERTS_UTILS_H_
