/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_wsalerts_dsrl.h
* @brief       Declaration of the Weather and Security Alerts DSRL functionalities.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*=============================================================================
=======                            DEFINES                              =======
=============================================================================*/
#ifndef _FC_SXM_TCL_WSALERTS_DSRL_H_
#define _FC_SXM_TCL_WSALERTS_DSRL_H_

/*=============================================================================
=======                            INCLUDES                             =======
=============================================================================*/
#include "fc_sxm_tcl_wsalerts_app.h"

/*=============================================================================
=======                             TYPES                               =======
=============================================================================*/
// Weather Security Alert -specific configuration of dsrl
struct fc_sxm_trWsAlertsDSRLCfg: public fc_sxm_trDSRLBaseCfg
{
	fc_sxm_trWsAlertsDSRLCfg(){
        //to solve lint warning 1401
        rFilterCfg.enWsAlertsMsgObjectType = (fc_sxm_tenWsAlertFilterMethod)fc_sxm_enWsAlertsFilterMethod_NONE;
        enSortMethod =  fc_sxm_enWsAlertSortMethod_NONE;

	};
	fc_sxm_trWsAlertsDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg) {
        u32Capacity=rGenericCfg.u32Capacity;
        rLocation=rGenericCfg.rLocation; /*Lat,Lon,Radius*/
        u32Radius=rGenericCfg.u32Radius;
        enSortMethod=(fc_sxm_tenWsAlertSortMethod)rGenericCfg.u8SortMethod;
		rFilterCfg.enWsAlertsMsgObjectType=(fc_sxm_tenWsAlertFilterMethod)rGenericCfg.u8FilterMethod;
    }
    virtual tVoid vPrintSpecific() const;
    fc_sxm_trWsAlertDSRLFilterCfg rFilterCfg;
	fc_sxm_tenWsAlertSortMethod enSortMethod;
};

/*=============================================================================
=======                              CLASSES                            =======
=============================================================================*/
class fc_sxm_tclWsAlertsDSRL :
   public fc_sxm_tclConfigDSRL<fc_sxm_trWsAlertsDSRLCfg>
{

public:
   // Constuctor
	   fc_sxm_tclWsAlertsDSRL(fc_sxm_tenDSRLType enDsrlType);

   //Destructor
   virtual ~fc_sxm_tclWsAlertsDSRL();



   //Update notification when the DSRL is ready and iterated
   virtual tVoid vOnDSRLUpdate(tVoid);

   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL, 
                                       DSRL_ENTRY_OBJECT hEntry);
   
   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);
   
   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL, 
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);

   virtual tVoid vHandleDsrlEntryInvalid (DSRL_ENTRY_ID tEntryID);
   tVoid vGetWSAlertInfo(fc_sxm_trWsAlertsListEntry& rListEntry,WS_ALERT_MSG_OBJECT& hWsAlertMsg) const;

   static BOOLEAN cb_GetWSAlertTypes(STRING_OBJECT hMsgType,void *pvArg);
   static BOOLEAN cb_WSAlertsIterateLocations(WS_ALERTS_LOCATION_OBJECT hWsAlertsLocation,void *pvIterateArg);
   static BOOLEAN cb_ShapePointsIterator(LOCATION_OBJECT hLocation,void* pvArg);
   tVoid  vMapWSAlertTypeId(fc_sxm_trWsAlertsListEntry &rListEntry) const;
};

#endif //_FC_SXM_TCL_WsAlerts_DSRL_H_
