/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_wsalerts_app.h
* @brief       Declaration of handling Weather and Security Alerts application functionalities.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*=============================================================================
=======                            DEFINES                              =======
=============================================================================*/
#ifndef _FC_SXM_TCL_WSALERTS_APP_H_
#define _FC_SXM_TCL_WSALERTS_APP_H_

// DSRL location for Weather Alerts for map : center of US
#define FC_SXM_WSALERTS_MAP_LATITUDE 39.828175F
#define FC_SXM_WSALERTS_MAP_LONGITUDE -98.5795F

/*=============================================================================
=======                            INCLUDES                             =======
=============================================================================*/
#include "fc_sxm_clienthandler_tts.h"
#include "fc_sxm_tcl_wsalerts_properties.h"
#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_tcl_wsalerts_list.h"

/*=============================================================================
=======                     FORWARD DECLARATIONS                        =======
=============================================================================*/
struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclWsAlertsDSRL;
struct fc_sxm_trWsAlertsDSRLCfg;
class fc_sxm_trWsAlertsList;
struct fc_sxm_trWsAlertsListEntry;

/*=============================================================================
=======                             TYPES                               =======
=============================================================================*/
// method-start from cca-service
struct fc_sxm_trMsgWsAlertsMStartGetWSAlertsMsgList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgListMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartSetWSAlertsConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 201);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsConfigMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartGetWSAlertMsgDetails: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 202);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgGetWSAlertMsgDetailsMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartSetListsConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 203);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgSetListsConfigMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartListModeSet: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 204);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgSxmListModeSet oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartGetWeatherAlertData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 205);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgGetWeatherAlertDataMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartAnnounceWSAlert: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 206);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgAnnounceWSAlertMethodStart oFiMsg;
};

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
/* messages send for timer concept */
struct fc_sxm_trMsgListUpdateWsAlertTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 216);
};
#endif

struct fc_sxm_trMsgWsAlertsMStartSetWSAlertsProjectConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 217);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgSetWSAlertsProjectConfigMethodStart oFiMsg;
};

struct fc_sxm_trMsgWsAlertsMStartValidateWSAlertMessage: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_WsAlerts, 218);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_wsalertsfi_tclMsgValidateWSAlertMessageMethodStart oFiMsg;
};
typedef enum
{
   fc_sxm_WSAlert_enStatus_Disabled,
   fc_sxm_WSAlert_enStatus_Enabled=1,
   fc_sxm_WSAlert_enStatus_UnSupported
}fc_sxm_tenWSAlertStatus;

struct fc_sxm_trRGBAcolor
{
   tU8 u8Red;
   tU8 u8Green;
   tU8 u8Blue;
   tU8 u8Alpha;
   fc_sxm_trRGBAcolor():
	   u8Red(0),
	   u8Green(0),
	   u8Blue(0),
	   u8Alpha(0)
   {

   }

};

struct fc_sxm_trWSAlertConfig
{
   string oExtRefCode;
   tU32 u32AlertTypeId;
   fc_sxm_tenWSAlertStatus e8Status;
   tU32 u32AlertNameID;
   tU32 u32AlertGroupId;
   tU32 u32AlertPrio;
   tBool bIsEnabledInHMI;
   tBool bIsEnabledInMap;
   fc_sxm_trRGBAcolor trRGBAcolors;
   fc_sxm_trWSAlertConfig():
	   oExtRefCode(""),
	   u32AlertTypeId(midw_ext_fi_tcl_e8_WSAlertTypes::FI_EN_INVALID_ALERT_TYPE),
	   e8Status(fc_sxm_WSAlert_enStatus_Enabled),
	   u32AlertNameID(0),
	   u32AlertGroupId(0),
	   u32AlertPrio(0),
	   bIsEnabledInHMI(FALSE),
	   bIsEnabledInMap(FALSE)
	   {

	   }

};

/*=============================================================================
=======                              METHODS                            =======
=============================================================================*/
// Weather Security Alerts-app class
class fc_sxm_tclWsAlertsApp :
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclWsAlertsApp>

{

 public:

    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_WsAlerts;

    //Destructor
    virtual ~fc_sxm_tclWsAlertsApp();

    //Initialize the WsAlerts service
    virtual tVoid vInitialize(tVoid);

    //DeInitialize the WsAlerts service
    virtual tVoid vDeInitialize(tVoid);

    inline tVoid vSetListReqType(tU8 u8ListReqType) { _u8ListReqType = u8ListReqType;}
    const inline tU8 u8GetListReqType () const { return _u8ListReqType; }

    const inline tBool bGetSendUpdate() const { return _bSendUpdate;}

    const inline tU32 u32GetUpdateCounter() const { return _u32UpdateCounter; }

    inline tVoid  vSetSendUpdate(tBool bSetSendUpdate) { _bSendUpdate = bSetSendUpdate;}

	tVoid vNotifyHmiErrorState();
	//function to check the variable enAudioSourceActivity to ignore source request when the source is already available
	const inline fc_sxm_enAudioSourceActivity enGetAudioSourceActivity() const {return enAudioSourceActivity;}

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING

    virtual tVoid vProcessTimer(fc_sxm_trMsgListUpdateWsAlertTimer const *prMsg);
    virtual tVoid vProcessTimer(fc_sxm_trMsgTTSTimer const *prMsg);
   /*
      start the timer for 10 seconds
   */
    tVoid vStartListTimer(tVoid);
    tVoid vStopListTimer(tVoid);
    tBool bIsListUpdateTimerRunning(tVoid) const;

#endif

    // To add entries into the Combined map
    tVoid vAddEntry(const fc_sxm_trWsAlertsListEntry& rListEntry);
    // To clear the Combined map
    tVoid vDeleteEntry(const fc_sxm_trWsAlertsListEntry& rListEntry);


    tVoid vPrintReportSpecific();

typedef  map<string,fc_sxm_trWSAlertConfig> trAlertConfig;

   const trAlertConfig &rGetAlertMapEntries() const {
     return _mapAlertConfig;
   }

 protected:

   // commands From CCA-Thread:
   //Start the service (Mandatory, dispatched by Base-Class)
   virtual tVoid vStartSmsService();

    virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);
    tVoid vSendWSAlertInfoListStatus();
    tVoid vSendCurrentWSAlerts(fc_sxm_tclDataListBase *poDataList);
    tVoid vSendWeatherAlertData();

    SXM_SMS_DATASRV_ACCESS(WS_ALERTS,_hWSAlertsService );

    virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);
    tVoid vClearServiceData(tVoid);
    // ttfis-cmds
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
    // dispatch thread-messages specific for WsAlerts-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

 private:

    //Constructor
    fc_sxm_tclWsAlertsApp();

    fc_sxm_tenListMode _enTestListMode;
    inline tVoid vSetAudioSourceActivity(fc_sxm_enAudioSourceActivity enSetAudioSourceActivity) {enAudioSourceActivity = enSetAudioSourceActivity;}

    tVoid vCreateDsrlAndList(fc_sxm_tenDSRLType enDsrlType, fc_sxm_tenListType enListType,
             fc_sxm_tclWsAlertsDSRL **ppoDsrl, fc_sxm_trWsAlertsList **ppoList , fc_sxm_trWsAlertsDSRLCfg rDsrlCfg);

   friend class fc_sxm_tclSingleton<fc_sxm_tclWsAlertsApp>;

   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartGetWSAlertsMsgList const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartSetWSAlertsConfig  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartGetWSAlertMsgDetails  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartGetWeatherAlertData  const *prMsg);

   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartSetListsConfig const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartListModeSet const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartAnnounceWSAlert  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartSetWSAlertsProjectConfig  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgWsAlertsMStartValidateWSAlertMessage  const *prMsg);

   tVoid vProcess(fc_sxm_trMsgWsAlertsAudioSource  const *prMsg);
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultPrepareVoiceOutput  const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultFirstSynthesizeSpeak  const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultMiddleSynthesizeSpeak  const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultLastSynthesizeSpeak  const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultAbortPrompt const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultPausePrompt const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientMResultContinuePrompt const *prMsg) const;
   tVoid vProcess(fc_sxm_trMsgTTSClientError  const *prMsg) const;
   
   tVoid vPrepareList(fc_sxm_trMsgWsAlertsMStartGetWSAlertsMsgList const *prMsg,tU32 u32ListId);
   tVoid vPrepareCustomList(fc_sxm_trMsgWsAlertsMStartGetWSAlertsMsgList const *prMsg);
   
   tBool bAnnounceWsAlert(fc_sxm_trMsgWsAlertsMStartAnnounceWSAlert  const *prMsg);
   tBool bStartWSALertAnnouncement(fc_sxm_tclTTSState* poCurrentState, string sWSAlertText);
   tBool bStopOrAbortWSALertAnnouncement(const fc_sxm_tclTTSState* poCurrentState, tBool bIsStop=FALSE) const;
   tBool bPasueWSALertAnnouncement(const fc_sxm_tclTTSState* poCurrentState) const;
   tBool bResumeWSALertAnnouncement(const fc_sxm_tclTTSState* poCurrentState) const;
   midw_ext_fi_tcl_e8_WSAlertAnnounceStatus::tenType enGetWSALertStatus() const;
   tVoid vNotifyWSAlertAnnounceStatus(midw_ext_fi_tcl_e8_WSAlertAnnounceStatus::tenType enStatus) const;
   tVoid vHandleAudioSourceOn();
   tVoid vHandleAudioSourceOff() const;


   fc_sxm_tenListState enGetCombinedListState(const fc_sxm_listStatusInfo& rNearByListInfo,
            const fc_sxm_listStatusInfo& rNearDestListInfo,fc_sxm_tenListState enNearByListState,
            fc_sxm_tenListState enNearDestListState) const;

   fc_sxm_tenWSAlertStatus enGetAlertStatus(fc_sxm_trMsgWsAlertsMStartSetWSAlertsConfig  const *prMsg) const;
   tVoid vConfigureWSAlerts(fc_sxm_trMsgWsAlertsMStartSetWSAlertsProjectConfig  const *prMsg);

   WS_ALERTS_SERVICE_OBJECT _hWSAlertsService;

   fc_sxm_tclWsAlertsDSRL *_poNearByDsrl;
   fc_sxm_tclWsAlertsDSRL *_poNearDestDsrl;

   fc_sxm_trWsAlertsList *_poNearByList;
   fc_sxm_trWsAlertsList *_poNearDestList;


   // Variable to hold no of requests for combined list
   tBool  _bSendUpdate;
   tU8 _u8ListReqType;

   //Variable to hold Audio source activity
   fc_sxm_enAudioSourceActivity enAudioSourceActivity;

   //Combined map for alert POP-UP <MSGID,InternalList>
   map<tU32,fc_sxm_trWsAlertsListEntry> _mapCombinedEntries;

   // Weather alert Config map <EXTREF,userConfig>
   map<string,fc_sxm_trWSAlertConfig> _mapAlertConfig;

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
	/* Timer to handle List updates */
    fc_sxm_tclTimer<fc_sxm_tclWsAlertsApp, 
        fc_sxm_trMsgListUpdateWsAlertTimer> _mListUpdateTimer;
#endif

    tU32 _u32WSAlertMsgID;
    fc_sxm_tclTimer<fc_sxm_tclWsAlertsApp, fc_sxm_trMsgTTSTimer> _otTTSTimer;
    tU8 _u8RetryCounter;
    tU32 _u32UpdateCounter;
};

#endif //_FC_SXM_TCL_WSALERTS_APP_H_
/*=============================================================================
=======                   END OF FILE                                   =======
=============================================================================*/
