/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_traffic_types.h
* @brief       Defines rdbid structure and the SDTP protocol headers
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef _FC_SXM_TCL_TRAFFIC_TYPES_H_
#define _FC_SXM_TCL_TRAFFIC_TYPES_H_

#include "fc_sxm_common.h"
#include "fc_sxm_sms.h"




/*=============================================================================
=======                            DEFINES                              =======
=============================================================================*/


#define SXM_TRAFFIC_RDBID_LIST_MAX_SIZE                  20
#define SXM_TRAFFIC_CAPABILITY_LIST_MAX_SIZE             13
#define SXM_TRAFFIC_DEFAULT_MSG_AMOUNT_VALUE             10
#define SXM_TRAFFIC_TMCCOUNTRYCODE                       0x01
#define SXM_TRAFFIC_MULTITUNERNOTSUPPORTED_VALUE          1

#define SXM_TRAFFIC_SERVICE_ID                           2


//#define SXM_TRAFFIC_PROGRAMSERVICENAME ""
//#define SXM_TRAFFIC_SERVICEPROVIDERNAME ""


#define SXM_TRAFFIC_BASE_INCIDENT_PSI           512
#define SXM_TRAFFIC_BASE_SPEED_AND_FLOW_PSI     544

#define SXM_NUM_TRAFFIC_MARKETS                 31


/* Constants for parsing the SDTP traffic header based on the protocol spec */
#define SXM_TRAFFIC_SDTP_SYNC_BYTE                      0x81
#define SXM_TRAFFIC_SDTP_SYNC_BYTELEN                   1
#define SXM_TRAFFIC_SDTP_ALL_MESSAGES_TXED_BITLEN       1
#define SXM_TRAFFIC_SDTP_RESERVED_PLUS_M_W_FLAGS_BITLEN 5
#define SXM_TRAFFIC_SDTP_S_FLAG_BITLEN                  1
#define SXM_TRAFFIC_SDTP_I_FLAG_BITLEN                  1
#define SXM_TRAFFIC_SDTP_MSG_COUNT_BITLEN               8
#define SXM_TRAFFIC_SDTP_MSG_TYPE_BITLEN                2
#define SXM_TRAFFIC_SDTP_MARKET_ID_BYTELEN              1
#define SXM_TRAFFIC_SDTP_REST_OF_HEADER_BITLEN          6

/*=============================================================================
 =======                            Structures                           =======
 =============================================================================*/

/* This data structure contains the parameters for rdbid */
typedef struct trTrafficRdbid
{
   tU8 u8LTN;
   tU16 u16BSA;
   tU8 u8CountryCode;
} trTrafficRdbid;

/* list of rdbid */
typedef struct trTrafficRdbidList
{
    tU8 u8ListSize;                                                  /* list size */
    trTrafficRdbid aoTrafficRdbid[SXM_TRAFFIC_RDBID_LIST_MAX_SIZE];  /* array of rdbid structure */
} trTrafficRdbidList;
/* to store the LTN and BSA */
/*typedef struct 
{
    tU16 u16Bsa;
    tU8  u8Ltn;
}trBsaAndLtn;
multimap<tU8, trBsaAndLtn>_mmapRdbid;*/

struct trLTN 
{
    tU16 u16Size;
    tU8  u8Ltn[SXM_TRAFFIC_RDBID_LIST_MAX_SIZE];
    trLTN ():
    	u16Size(0)
    {
		memset(u8Ltn,0x00,sizeof(u8Ltn));
    }
};


/* Tuner state and operation mode structure */
typedef struct trTunerStateAndOperationMode
{
    tU8 u8TunerState;
    tU8 OperationMode;
} trTunerStateAndOperationMode;

#endif /* _FC_SXM_TCL_TRAFFIC_TYPES_H_ */

