/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_traffic_properties.h
* @brief       Declaration traffic service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_TCL_TRAFFIC_PROPERTIES_H
#define FC_SXM_TCL_TRAFFIC_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_traffic_fi.h"
#include "fc_sxm_audio_fi.h"

/* Semaphore-protected data of traffic-app */


/* for property RdbidActualList, where fi-type is stored directly in member "oFiMsg" */


struct fc_sxm_tcl_trTrafficPropertyRdbidActualList 
{
    /* constructor */
    fc_sxm_tcl_trTrafficPropertyRdbidActualList()
    {
        
    }
    /* comparision operator */
    bool operator!=(fc_sxm_tcl_trTrafficPropertyRdbidActualList const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    
    /* any data that need to be stored follow: */
    sxm_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus oFiMsg;
    
};

/* for property TunerStateAndMode */
struct fc_sxm_tcl_trTrafficPropertyTunerStateAndMode 
{
    /* constructor */
    fc_sxm_tcl_trTrafficPropertyTunerStateAndMode()
    {
        
    }
    /* comparision operator */
    bool operator!=(fc_sxm_tcl_trTrafficPropertyTunerStateAndMode const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    
    /* any data that need to be stored follow: */
    sxm_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus oFiMsg;
    
};

/* for property TMCData */
struct fc_sxm_tcl_trTrafficPropertyTMCData
{
    /* constructor */
    fc_sxm_tcl_trTrafficPropertyTMCData()
    {
        
    }
    /* comparision operator */
    bool operator!=(fc_sxm_tcl_trTrafficPropertyTMCData const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    
    /* any data that need to be stored follow: */
    sxm_tclMsgFID_TRAFFIC_G_TmcDataStatus oFiMsg;
    
};

/* for property TMCInfo */
struct fc_sxm_tcl_trTrafficPropertyTMCInfo
{
	/* constructor */
	fc_sxm_tcl_trTrafficPropertyTMCInfo()
	{

	}
	/* comparision operator */
	bool operator!=(fc_sxm_tcl_trTrafficPropertyTMCInfo const& b) const
	{
		return !(oFiMsg==b.oFiMsg);
	 }
	 /* any data that need to be stored follow: */
	 sxm_tclMsgFID_TRAFFIC_G_TmcInfoStatus oFiMsg;

};


/* class for all the traffic properties */
class fc_sxm_tclTrafficProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclTrafficProperties>
{

    friend class fc_sxm_tclSingleton<fc_sxm_tclTrafficProperties>;
 public:
    /* for RdbidActualList property */
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTrafficPropertyRdbidActualList, 
        CCA_C_U16_SRV_SXM_TRAFFIC,          /* the service-id of the CCA-Service */
        MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_RDBIDACTUALLIST  /* give FID if notification to service is needed  */
        > oUpdateRdbidActualList;

    /* for TunerStateAndMode property */
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTrafficPropertyTunerStateAndMode, 
        CCA_C_U16_SRV_SXM_TRAFFIC,            /* the service-id of the CCA-Service */
        MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TUNERSTATEANDMODE  /* give FID if notification to service is needed  */
        > oUpdateTunerStateAndMode;

    /* for TMCData property */
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTrafficPropertyTMCData, 
        CCA_C_U16_SRV_SXM_TRAFFIC,              /* the service-id of the CCA-Service */
        MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCDATA      /* give FID if notification to service is needed  */
        > oUpdateTmcData;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trTrafficPropertyTMCInfo,
        CCA_C_U16_SRV_SXM_TRAFFIC,              /* the service-id of the CCA-Service */
		MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCINFO      /* give FID if notification to service is needed  */
        > oUpdateTmcInfo;


};

#endif /* FC_SXM_TCL_TRAFFIC_PROPERTIES_H */
