/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tabweather_list.cpp
* @brief       Implementation of handling Tabweather information to the HMI
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*=============================================================================
=======                            INCLUDES                             =======
=============================================================================*/
#include "fc_sxm_common.h"
#include "fc_sxm_tcl_tabweather_list.h"
#include "fc_sxm_tabweather_fi.h"
#include "fc_sxm_service_sxm_tabweather.h"
#include "fc_sxm_tcl_tabweather_app.h"
#include "fc_sxm_sms_util.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_TABWEATHER_APP
#include "trcGenProj/Header/fc_sxm_tcl_tabweather_list.cpp.trc.h"
#endif


tVoid fc_sxm_trTabweatherListConfig::vPrintSpecific() const {
    ETG_TRACE_FATAL_CLS((TR_CLASS_FC_SXM_REPORT, "\t\t\t\t\tenFilter=%d", ETG_CENUM(WEATHER_MSG_OBJECT_TYPE_ENUM, rFilterCfg.enWeatherMsgObjectType)));
}

bool fc_sxm_trTabweatherList::bCompareItem(fc_sxm_trTabweatherListEntry const *prLeft, fc_sxm_trTabweatherListEntry const *prRight) const {
   (tVoid) prLeft;
   (tVoid) prRight; /*To Suppress lint warnings*/
   return true;
}

bool fc_sxm_trTabweatherList::bFilterPassed(fc_sxm_trTabweatherListEntry const &rItem) const {
   ETG_TRACE_USR4(("fc_sxm_trTabweatherList::bFilterPassed"));
   (tVoid) rItem; /*To Suppress lint warnings*/
   return true;
}

/*********************************************************************
 *FUNCTION:     vEmit
 *DESCRIPTION:  Update the FI-entry from the list and send message
 *PARAMETER:    1)Msg address (GetTabWeatherInfoList or AddFavorite)
 *RETURNVALUE:  None
 ********************************************************************/
tVoid fc_sxm_trTabweatherList::vEmit(fc_sxm_trAdressing const &rAdressing) 
{
   tU32 u32ListId = u32GetId();
   ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit START,List id=%d",u32ListId));

   midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodResult oMRes;
   midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodResult oMResFav;
	midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodResult oMResGetFavInfo;
    
   tBool bIsFavorite = ((tU32) fc_sxm_tenListType_Favorites == u32ListId) ? TRUE : FALSE;
   oMResFav.FavStatus = FALSE;
   tBool bFavLocIdAvailable = FALSE;

   SXM_FOREACH_CONST(trSortedSetType, ite, rGetSortedEntries()) 
   {
		/*Get sorted entries in the selected list type*/
      fc_sxm_trTabweatherListEntry const *poEntry=*ite;
      midw_ext_fi_tcl_WeatherInfo oFiEntry;
      ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit:SXM_FOREACH_CONST - START"));
        
      SXM_FOREACH_MAP_CONST(WEATHER_FORECAST_TYPE_ENUM, fc_sxm_trTabweatherTypeListEntry, iter, poEntry->listTabweatherTypes)
      {
			/*Get Weather parameters for each forecast type*/
			if (bIsFavorite)
			{
				if((fc_sxm_tclTabweatherApp::instance()->GetLocidForFav()) == poEntry->u32SxmId)
				{
					bFavLocIdAvailable = TRUE;  /*Needed LOCID is present*/
				}
				else
				{
					break; /*Other LOCID's data need not be checked*/
				}
			}
         oFiEntry.WeatherForecastType.enType = (midw_ext_fi_tcl_e8_ForecastType::tenType)iter->second.enForecastType;
         oFiEntry.EventCode = iter->second.u8EventCode;
         fc_sxm_vString2Fi(iter->second.oDescription.c_str(),oFiEntry.EventDescription);
         oFiEntry.TabWeather_LOCID = iter->second.u32TabweatherLocId;
         fc_sxm_vString2Fi(iter->second.oWeatherStation.c_str(),oFiEntry.WeatherStationName);
         fc_sxm_vString2Fi(iter->second.oStateName.c_str(),oFiEntry.WeatherStateName);
         //oFiEntry.WeatherStateName.bSet(iter->second.oStateName.c_str(),midw_ext_fi_tclString::FI_EN_UTF8);
         oFiEntry.CurrentTemperature = iter->second.s16CurrentTemp;
         oFiEntry.TemperatureHigh = iter->second.s16TempHigh;
         oFiEntry.TemperatureLow = iter->second.s16TempLow;
         oFiEntry.PrecipitationChance = iter->second.u8PrecipitationChance;
         oFiEntry.PrecipitationAmountRangeLow = iter->second.f32PrecipitationAmountRangeLow;
         oFiEntry.PrecipitationAmountRangeHigh = iter->second.f32PrecipitationAmountRangeHigh;
         oFiEntry.WindSpeed = iter->second.u8WindSpeed;
         oFiEntry.WindDirection = iter->second.u16WindDirection;
         oFiEntry.HumidityRangeLow = iter->second.u8HumidityRangeLow;
         oFiEntry.HumidityRangeHigh = iter->second.u8HumidityRangeHigh;
         oFiEntry.UV_InfoRangeLow = iter->second.u8UVInfoRangeLow;
         oFiEntry.UV_InfoRangeHigh = iter->second.u8UVInfoRangeHigh;
         oFiEntry.PollenLevel.enType = (midw_ext_fi_tcl_e8_PollenLevelType::tenType)iter->second.enPollenLevel;
         oFiEntry.AirQuality.enType = (midw_ext_fi_tcl_e8_AirQualityType::tenType)iter->second.enAirQuality;
         oFiEntry.CloudCover.enType = (midw_ext_fi_tcl_e8_CloudCoverType::tenType)iter->second.enCloudCover;
         oFiEntry.ForecastTimeStamp = iter->second.u32TimeStamp;

         vPrintFIFields(oFiEntry);

         if (!bIsFavorite)
         {
				/*Load the data for GetTabweatherInfoList Methodresult*/
            oMRes.TabWeatherInfo.WeatherInfolist.push_back(oFiEntry);
         }
         else if(bFavLocIdAvailable)
         {
				if (!fc_sxm_tclTabweatherApp::instance()->bGetbGetFavInfoFlag())
				{
					/*Fav. Methodresult*/
					oMResFav.TabWeatherInfo.WeatherInfolist.push_back(oFiEntry);
					oMResFav.FavStatus = TRUE;  
				}
				else
				{
					/*GetFavInfo. Methodresult*/
					oMResGetFavInfo.TabWeatherInfo.WeatherInfolist.push_back(oFiEntry);
				}
         }
      }/*End of SXM_FOREACH_MAP*/   
        
    ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit:SXM_FOREACH_CONST - END"));
   }/*End of SXM_FOREACH_CONST*/

	if (!bIsFavorite)
	{
		/*GetTabweatherInfoList Methodresult*/
		ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit(GetTabweatherInfoList):enSendFiMessage")); 
		oMRes.ListId = u32ListId;
		fc_sxm_tclTabweatherService::instance()->enSendFiMessage(rAdressing, oMRes);
	}
	else
	{
		if (!fc_sxm_tclTabweatherApp::instance()->bGetbGetFavInfoFlag())
		{
			/*AddFavorite Methodresult*/
			ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit(AddFav.):enSendFiMessage")); 
			fc_sxm_tclTabweatherService::instance()->enSendFiMessage(rAdressing, oMResFav);
		}
		else
		{
			/*GetFavInfo. Methodresult*/
			ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit(GetFavInfo.):enSendFiMessage"));
			fc_sxm_tclTabweatherService::instance()->enSendFiMessage(rAdressing, oMResGetFavInfo);
		}
		bFavLocIdAvailable = FALSE;
		fc_sxm_tclTabweatherApp::instance()->vSetLocidForFav(0);
	}
   ETG_TRACE_USR4(("fc_sxm_trTabweatherList::vEmit END"));
}

tVoid fc_sxm_trTabweatherList::vPrintFIFields (const midw_ext_fi_tcl_WeatherInfo& oFiEntry) const
{
	ETG_TRACE_USR4(("===========fc_sxm_trTabweatherList::vPrintFIFields START==========="));
    ETG_TRACE_USR4(("ForecastType=%d, EventCode=%d, LOCID=%d, AirQuality=%d",
                    oFiEntry.WeatherForecastType.enType,
                    oFiEntry.EventCode,
                    oFiEntry.TabWeather_LOCID,
                    oFiEntry.AirQuality.enType
                    ));

    ETG_TRACE_USR4(("WeatherStationName=%s", oFiEntry.WeatherStationName.szValue ));
    ETG_TRACE_USR4(("EventDescription=%s", oFiEntry.EventDescription.szValue));
    ETG_TRACE_USR4(("WeatherStateName=%s", oFiEntry.WeatherStateName.szValue ));

    ETG_TRACE_USR4(("\nfc_sxm_trTabweatherList::vEmit: CurrentTemp=%d, TempLow=%d, TempHigh=%d, PrecipChance=%d",
                    oFiEntry.CurrentTemperature,
                    oFiEntry.TemperatureLow,
                    oFiEntry.TemperatureHigh,
                    oFiEntry.PrecipitationChance
                    ));

    ETG_TRACE_USR4(("\nfc_sxm_trTabweatherList::vEmit: PrecipAmountLow=%f, PrecipAmountHigh=%f, WindSpeed=%d, WindDirection=%d",
                    oFiEntry.PrecipitationAmountRangeLow,
                    oFiEntry.PrecipitationAmountRangeHigh,
                    oFiEntry.WindSpeed,
                    oFiEntry.WindDirection
                    ));

    ETG_TRACE_USR4(("\nfc_sxm_trTabweatherList::vEmit: HumidityLow=%f, HumidityHigh=%f, UVInfoLow=%d, UVInfoHigh=%d, PollenLevel=%d",
                    oFiEntry.HumidityRangeLow,
                    oFiEntry.HumidityRangeHigh,
                    oFiEntry.UV_InfoRangeLow,
                    oFiEntry.UV_InfoRangeHigh,
                    oFiEntry.PollenLevel.enType
                    ));

    ETG_TRACE_USR4(("CloudCover = %u\t ForecastTimeStamp = %u", oFiEntry.CloudCover.enType, oFiEntry.ForecastTimeStamp));
	ETG_TRACE_USR4(("===========fc_sxm_trTabweatherList::vPrintFIFields END==========="));
}


/*=============================================================================
=======                   END OF FILE                                   =======
=============================================================================*/

