/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_tabweather_app.h
* @brief       Declaration of handling HMI requests and functionalities of the
*              TabWeather service
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

/*=============================================================================
=======                            INCLUDES                             =======
=============================================================================*/
#ifndef _FC_SXM_TCL_TABWEATHER_APP_H_
#define _FC_SXM_TCL_TABWEATHER_APP_H_

#include "fc_sxm_tabweather_fi.h"
#include "fc_sxm_tcl_tabweather_properties.h"
#include "fc_sxm_tcl_data_app.h"

struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclTabweatherDSRL;
//to solve lint info 1730
struct fc_sxm_trTabweatherDSRLCfg;
class fc_sxm_trTabweatherList;
struct fc_sxm_trTabweatherListEntry;

// messges representing callbacks from sms
struct fc_sxm_trMsgTabweatherSmsEvtFilter: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 101);
};

struct fc_sxm_trMsgTabweatherSmsEvtSort: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 102);

};


// method-start from cca-service
struct fc_sxm_trMsgTabweatherMStartGetTabweatherInfoList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_tabweatherfi_tclMsgGetTabWeatherInfoListMethodStart oFiMsg;
};

struct fc_sxm_trMsgTabweatherMStartAddFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 201);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_tabweatherfi_tclMsgAddFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trMsgTabweatherMStartRemoveFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 202);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_tabweatherfi_tclMsgRemoveFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trMsgTabweatherMStartGetFavoriteInfo: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 203);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_tabweatherfi_tclMsgGetFavoriteInfoMethodStart oFiMsg;
};

struct fc_sxm_trMsgTabweatherMStartSetListsConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 204);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_tabweatherfi_tclMsgSetListsConfigMethodStart oFiMsg;
};
struct fc_sxm_trPropertyTabweatherPSetListMode: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Tabweather, 205);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_tabweatherfi_tclMsgSxmListModeSet oFiMsg;
};
// Structure to hold Weather_ref.db values
 struct fc_sxm_trTabweatherDatabase {
	tF32 f32latitue;
	tF32 f32longitude;
	LOC_ID un32locid;
	LOCATION_OBJECT hLocation;

	/** Parameterised constructor**/
	fc_sxm_trTabweatherDatabase(tF32 f32Lat, tF32 f32Long, LOC_ID un32LocId, LOCATION_OBJECT  hLocObj) :
	f32latitue(f32Lat), f32longitude(f32Long), un32locid(un32LocId), hLocation(hLocObj) { };

	/** Default constructor**/
	fc_sxm_trTabweatherDatabase() : f32latitue(0.0f), f32longitude(0.0f), un32locid(0u), hLocation (LOCATION_INVALID_OBJECT) { }
};

// Structure to hold Weather db values and distance
 struct fc_sxm_trDistanceDatabase {
	tF32 f32latitue;
	tF32 f32longitude;
	LOC_ID un32locid;
	tF32 f32distance;
};
// Structure to hold Target Latitude and Longitude Points
struct fc_sxm_trTargetLoc
{
	tF32 f32latitue;
	tF32 f32longitude;
};
template <typename T, typename U>
struct CompareByMember {
	// This is a pointer-to-member, it represents a member of class T
	// The data member has type U
	U T::*field;
	CompareByMember(U T::*f) : field(f) {}
	bool operator()(const T &lhs, const T &rhs) {
		return lhs.*field < rhs.*field;
	}
};

// tabweather-app class
class fc_sxm_tclTabweatherApp :
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclTabweatherApp>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclTabweatherApp>;

 public:

    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Tabweather;

    //Destructor
    virtual ~fc_sxm_tclTabweatherApp();

    //Initialize the Tabweather service
    virtual tVoid vInitialize(tVoid);

    //DeInitialize the Tabweather service
    virtual tVoid vDeInitialize(tVoid);

    // dispatch thread-messages specific for Tabweather-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    DSRL_OBJECT GetFavDsrl() const;

    tVoid vSendFavList(LOC_ID un32Loc_id,tBool bStatus);

    inline tVoid vSetbGetFavInfoFlag (tBool bStatus) { _bGetFavInfoFlag = bStatus; /* To indicate the method start for GetFavoriteInfo*/}
    inline tBool bGetbGetFavInfoFlag () { return _bGetFavInfoFlag; /* To indicate the method start for GetFavoriteInfo*/}

    inline tVoid vSetbSetAsFavFlag (tBool bStatus) { _bSetAsFavFlag = bStatus; /*To invoke the Methodresult for AddFavorite only once*/}
    inline tBool bGetbSetAsFavFlag () { return _bSetAsFavFlag; /*To invoke the Methodresult for AddFavorite only once*/}

    inline tVoid vSetLocidForFav(LOC_ID tLocId) {  _tLocIdForFav = tLocId;  /*To get data for selected LOCID in vEmit*/}
    inline LOC_ID GetLocidForFav()    {  return _tLocIdForFav;   /*To get data for selected LOCID in vEmit*/  }

	 static tBool bWeatherLocationsIterator( LOCATION_OBJECT hLocation,tVoid *pvIterateArg);

 protected:
    virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);


    SXM_SMS_DATASRV_ACCESS(WEATHER, _hTabweather);

    // commands From CCA-Thread:
    //Start the service (Mandatory, dispatched by Base-Class)
    virtual tVoid vStartSmsService();

 private:
	// ttfis-cmds
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

    // messages specific for app go from here
    // fi-messages

   virtual tVoid vProcess(fc_sxm_trMsgTabweatherMStartGetTabweatherInfoList  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgTabweatherMStartAddFavorite const  *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgTabweatherMStartRemoveFavorite const  *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgTabweatherMStartSetListsConfig  const *prMsg);
   virtual tVoid vProcess(fc_sxm_trMsgTabweatherMStartGetFavoriteInfo const  *prMsg);
   virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const  *prMsg);
   virtual tVoid vProcess(fc_sxm_trPropertyTabweatherPSetListMode  const *prMsg);
     /* called to clear user-data, default implementation:
      vSetUsrDataClearResult(fc_sxm_enDiagResult_NoAction)
      if app has to to something, vSetUsrDataClearResult has to be called
      with appropriate code (fc_sxm_enDiagResult_Ok or fc_sxm_enDiagResult_Failed)
      after action is done, e.g.
      audio: set default channel, delete presets,
      data: clear favorites
   */
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);


 private:
   //Constructor
   fc_sxm_tclTabweatherApp();

   tVoid vCreateDsrlAndList(fc_sxm_tenDSRLType enDsrlType, fc_sxm_tenListType enListType, fc_sxm_tclTabweatherDSRL **ppoDsrl, fc_sxm_trTabweatherList **ppoList, fc_sxm_trTabweatherDSRLCfg rDsrlCfg);
   tBool bCheckLocationBoundary(tS32 s32Latitude, tS32 s32Longitude) const;

   WEATHER_SERVICE_OBJECT _hTabweather;
   fc_sxm_tclTabweatherDSRL *_poNearByDsrl;
   fc_sxm_tclTabweatherDSRL *_poNearDestDsrl;
   fc_sxm_tclTabweatherDSRL *_poAnotherLocationDsrl;
   fc_sxm_tclTabweatherDSRL *_poFavoritesDsrl;

   fc_sxm_trTabweatherList *_poNearByList;
   fc_sxm_trTabweatherList *_poNearDestList;
   fc_sxm_trTabweatherList *_poAnotherLocationList;
   fc_sxm_trTabweatherList *_poFavoritesList;
   fc_sxm_trTabweatherDatabase _trWeatherDB;
   vector <fc_sxm_trTabweatherDatabase> _TabweatherDBlist;

   fc_sxm_trAdressing _rSendFavAddressing;
   LOC_ID _tLocIdForFav;
   tBool _bSetAsFavFlag;
   tBool _bGetFavInfoFlag;

};

#endif //_FC_SXM_TCL_TABWEATHER_APP_H_
/*=============================================================================
=======                   END OF FILE                                   =======
=============================================================================*/

