/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_stocks_dsrl.h
* @brief       Declaration of Stocks DSRL for favorites.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_STOCKS_DSRL_H_
#define _FC_SXM_TCL_STOCKS_DSRL_H_

/******************************************
 * Header Files
 *******************************************/
#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_stocks_types.h"

/******************************************
 * Stocks-specific configuration of dsrl
 *******************************************/
struct fc_sxm_trStocksDSRLCfg:public fc_sxm_trDSRLBaseCfg
{
public:
	// Default constructor
	fc_sxm_trStocksDSRLCfg(): enSortMethod(fc_sxm_enStocksDSRLSortMethod_INVALID)
	{
		rFilterCfg.enFilterCfg = fc_sxm_enStocksDSRLFilterConfig_NONE;
	}
	// Copy constructor
	fc_sxm_trStocksDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg)
	{
		// Capacity, location and Radius are copied into respective member variables
		u32Capacity=rGenericCfg.u32Capacity;
		rLocation=rGenericCfg.rLocation;
		u32Radius=rGenericCfg.u32Radius;
		enSortMethod=(fc_sxm_tenStocksDSRLSortMethod)rGenericCfg.u8SortMethod;
		rFilterCfg.enFilterCfg = fc_sxm_enStocksDSRLFilterConfig_NONE;
	}

	virtual tVoid vPrintSpecific() const;
	fc_sxm_tenStocksDSRLSortMethod enSortMethod;
	fc_sxm_trStocksDSRLFilterCfg rFilterCfg;
};

/******************************************
 * Forward Declaration
 *******************************************/
struct fc_sxm_trStockQuoteListEntry;

/******************************************
 * Stocks-specific DSRL class
 *******************************************/
class fc_sxm_tclStocksDSRL :
	public fc_sxm_tclConfigDSRL<fc_sxm_trStocksDSRLCfg>
{

 public:
		// Constuctor
		fc_sxm_tclStocksDSRL(fc_sxm_tenDSRLType enDsrlType);

		//Destructor
		virtual ~fc_sxm_tclStocksDSRL();

		//Update notification when the DSRL is ready and iterated
		virtual tVoid vOnDSRLUpdate(tVoid);

		virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL,
				DSRL_ENTRY_OBJECT hEntry);

		virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
				DSRL_ENTRY_OBJECT hEntry1,
				DSRL_ENTRY_OBJECT hEntry2);

		virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL,
				DSRL_ENTRY_ID tEntryID,
				DSRL_ENTRY_STATUS_ENUM eStatus,
				DSRL_ENTRY_OBJECT hEntryObject);

		virtual tVoid vHandleDsrlEntryInvalid(DSRL_ENTRY_ID tEntryID);
 private:
		// Method to assign invalid stock values
		tVoid vAssignInvalidStockValues (fc_sxm_trStockQuoteListEntry *poStockQuoteListEntry, tU8 enDirection = 0u) const;
};

#endif //_FC_SXM_TCL_STOCKS_DSRL_H_

/*=============================================================================
  =======                   END OF FILE                                   =======
  =============================================================================*/

