/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_stocks_app.h
* @brief       Application handler declaration for Stocks service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_STOCKS_APP_H_
#define _FC_SXM_TCL_STOCKS_APP_H_

/******************************************
 * Header Files
 *******************************************/
#include "fc_sxm_stocks_fi.h"
#include "fc_sxm_tcl_stocks_properties.h"
#include "fc_sxm_tcl_data_app.h"

/******************************************
 * TYPEDEFS
 *******************************************/
typedef vector < midw_ext_fi_tclString > fc_sxm_trVectorSymbolFilter;


/******************************************
 * Forward declarations
 *******************************************/
struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclStocksDSRL;
class fc_sxm_trStocksList;
class fc_sxmTimeProfile;


/******************************************
 * Method-start from cca-service
 *******************************************/
struct fc_sxm_trMsgStocksMStartGetFavoriteStockSymbols: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 200);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgGetFavoriteStockSymbolsMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartAddFavorite: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 201);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgAddFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartRemoveFavorite: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 202);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgRemoveFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartGetStockSymbolsByFilter: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 203);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartGetDataProviderInfo: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 204);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgGetDataProviderInfoMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartSetListsConfig: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 206);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgSetListsConfigMethodStart oFiMsg;
};

struct fc_sxm_trMsgStocksMStartGetStockSymbolsByFilterPS: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 207);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodStart oFiMsg;
};

struct fc_sxm_trPropertyStockPSetListMode: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 208);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgSxmListModeSet oFiMsg;
};

struct fc_sxm_trMsgStocksMStartClearAllFavorites: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 209);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_stocksfi_tclMsgClearAllFavoritesMethodStart oFiMsg;
};

struct fc_sxm_trStocksTimer: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Stocks, 209);
};

/******************************************
 * Stocks-app class
 *******************************************/
class fc_sxm_tclStocksApp :
	public fc_sxm_tclDataApp,
	public fc_sxm_tclSingleton<fc_sxm_tclStocksApp>

{
	friend class fc_sxm_tclSingleton<fc_sxm_tclStocksApp>;
	friend class fc_sxm_tclTimer<fc_sxm_tclStocksApp,
                                         fc_sxm_trStocksTimer>;

 public:
	static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Stocks;
	//Destructor
	virtual ~fc_sxm_tclStocksApp();
	//Initialize the stocks service
	virtual tVoid vInitialize(tVoid);
	//DeInitialize the stocks service
	virtual tVoid vDeInitialize(tVoid);
	// dispatch thread-messages specific for stocks-app
	tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

	//Method to append stock symbol to internal set _setAllStockSymbols
	tVoid vAppendStockSymbol ( string &strStockSymbol );
	// Start Timer -- Expiry on which would result in List Status Changed event would be generated
	tVoid vStartStocksTimer(tU32 &msecDuration);

	tU32 u32GetFavoriteIndex(const string& strStockSymbol) const;

 protected:
	virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
	virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);
	SXM_SMS_DATASRV_ACCESS(STOCK_TICKER, _hStockticker);
    //over ridden from data app to clear the old data during re-initialization of sms service.
    tVoid vClearServiceData(tVoid);

    // commands From CCA-Thread:
     //Start the service (Mandatory, dispatched by Base-Class)
     virtual tVoid vStartSmsService();

    //Favorite methods to be implemented
    virtual tVoid vRestoreFavorites();
    virtual tVoid vPersistFavorites();
 private:
	// ttfis-cmds
	virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

	// message handler for different FI methods
	// fi-messages

	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartGetFavoriteStockSymbols const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartAddFavorite const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartRemoveFavorite const*prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartGetStockSymbolsByFilter const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartGetDataProviderInfo const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartSetListsConfig const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartGetStockSymbolsByFilterPS const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgStocksMStartClearAllFavorites const *prMsg);
	virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);
	virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);
	virtual tVoid vProcess(fc_sxm_trPropertyStockPSetListMode  const *prMsg);
	virtual tVoid vProcessTimer(fc_sxm_trStocksTimer const *prMsg);


	//Member functions declaration
	tBool bIsStockSymbolsUpdated ( tVoid );
	tU8 u8getAllKnownSymbols ( tVoid );
	tVoid vCreateFavoritesDsrl ( tVoid );
	DATASERVICE_STATE_ENUM u8getStockTickerServiceState ( tVoid );
	tVoid vDsrlIterate(tVoid) const;

	// Method to get stocks symbols by Filter for zero Characters
	tVoid vGetStocksByFilterForZeroChars( midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult &oMRes ) const;

	// Overload same method vGetStocksByFilter for Predictive Speller Support
	tVoid vGetStocksByFilter(string &strSearchFilter,
			midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult &oMRes, tBool bIsBackSpace) const;
	tVoid vGetStocksByFilter(const string &strSearchFilter, fc_sxm_trVectorSymbolFilter& vecStocksSymbol) const;
	STOCK_SYMBOL_OBJECT getStockSymbolObject (tCString chStockSymbol) const;
	SMSAPI_RETURN_CODE_ENUM enSetFavoriteStockSymbol (STOCK_SYMBOL_OBJECT hStockSymbol, tBool bSetFavorite) ;
	tVoid vClearAllFavorites( tVoid );

	// Methods Added for Stocks Timer implementation
   //stop timer
   tVoid vStopStocksTimer(tVoid);
   // timer checking
   tBool bIsStocksTimerRunning(tVoid) const;
   // to notify timeout
   tVoid vStocksTimerNotifyTimeOut(tVoid);
   // Add 5 stock symbols at one shot
   tVoid vAdd5StockSymbols( tVoid );
   //Method to convert TTFIs string to FI string
   tVoid vConvertTTFisStringtoFIString( tCString chInString, midw_ext_fi_tclString& rffiObj) const;
   //Method to  print Stock servicd, Favorites DSRL State and SMS version thru TTFI
   tVoid vPrintStocksServiceAndDsrlStates( tVoid );

   // Method fills stocks symbols if the stocks count <= 6
   tVoid vSpellerFillStocksList(midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult &oMRes,
		   vector < string >& vectListBuffer, const tU32 u32ListCount) const;
   // Method fills characters to be enabled in keypad
   tVoid vSpellerFillCharstoEnable(midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult &oMRes,
		   set < tChar >& setEnableChar) const;
   // Method fills display string and count for stocks speller
   tVoid vSpellerFillDispStringandCount(midw_ext_sxm_stocksfi_tclMsgGetStockSymbolsByFilterPSMethodResult &oMRes,
		   const string &strSearchFilter, const tU32 u32ListCount ) const;

   tVoid vAddFavorite(const string& strStockSymbol);
   tVoid vRemoveFavorite(const string& strStockSymbol);
   tVoid vClearFavoriteStockSymbols();
   tVoid vSaveFavoriteStockSymbols();
   tVoid vLoadFavoriteStockSymbols();

 private:
	//Constructor
	fc_sxm_tclStocksApp();
 private:
	//Constants and typedefs specific to the class
	typedef set < string > fc_sxm_trAllStockSymbols;

	// Member variables declaration
	STOCK_TICKER_SERVICE_OBJECT _hStockticker;
	fc_sxm_tclStocksDSRL *_poFavoritesDSRL;
	fc_sxm_trStocksList *_poStocksList;
	tU32 _u32DSSTVersion ;

	// _setAllStockSymbols stores all known stock symbols
	fc_sxm_trAllStockSymbols _setAllStockSymbols;
	/*  _strCharsToEnable stores the keypad characters to be enabled when no
	 * characters are entered in speller's text entry box */
	string _strCharsToEnable;

    /* Timer to handle
     * 1) to update Property Data Provider Info Status
     * 2) Update Stock status from Loading to Unknown*/
    fc_sxm_tclTimer<fc_sxm_tclStocksApp,
                          fc_sxm_trStocksTimer> _mStocksTimer;

    vector<string> _vecFavStockList;
};

#endif //_FC_SXM_TCL_STOCKS_APP_H_
/*=============================================================================
  =======                   END OF FILE                                   =======
  =============================================================================*/

