/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_nonteam.h
* @brief       base class for Non-Team Sport types.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_NONTEAM_H_
#define _FC_SXM_TCL_SPORTS_NONTEAM_H_
 
#include "fc_sxm_tcl_sports_base.h"

/*******************************************************************/
/* Class declaration for NON-TEAM SPORTS
 ******************************************************************/
class fc_sxm_tclNonTeamSports : public fc_sxm_tclSportsBase
{
public:
	fc_sxm_tclNonTeamSports ();

	virtual tVoid vGetEventRankList(tU32 u32LeagueID, tU8 u8EventType, tS32 s32TableParam, tS32 s32TableRef, fc_sxm_trAdressing const &rAdressing);

	virtual tBool bExtractScheduleRow(tVoid* pHandle, SXMSportsRow &TableRow, tS32 s32TableParam,tU32 u32EpochValue, tBool bIsTeamBased)
	{ /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)pHandle;
		(tVoid)TableRow;
		(tVoid)s32TableParam;
		(tVoid)u32EpochValue;
		(tVoid)bIsTeamBased;
		return FALSE;
	}

	virtual tBool bExtractEventRankListRow(SXMSportsRow &TableRow)
	{ /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)TableRow;
		return FALSE;
	}

	virtual tVoid vGetTopTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing)
	{ /* Implementation to be done */
		//to solve prio2 lint info 715
		(tVoid)u32LeagueID;
		(tVoid)rAdressing;
	}

	virtual tVoid vEmit(tU32 u32GameID,fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vEmitRankList(fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vClearSchedulesList(){ /* Derived classes to Override this method*/ }
	virtual tVoid vClearEventRankList(){ /* Derived classes to Override this method*/ }
	virtual tVoid vGetRankedList(tU8 u8LeagueID,tU32 u32RankedLIstTableRef){
		/*Implementation pending*/
		//to solve prio2 lint info 715
		(tVoid)u8LeagueID;
		(tVoid)u32RankedLIstTableRef;
		}
	virtual tU8 u8GetRankedListIndex() const { return 0u; /* Derived classes to Override this method*/}

	virtual tU32 u32GetEventListIndex(tU32 u32EventID)const{
		(tVoid)u32EventID;
		return 0u; /* Derived classes to Override this method*/}

	virtual tVoid vCopySchedulesToFI(midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &oMRes) const
	 { /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)oMRes;
	 }

	virtual tVoid vPrintSchedules(midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &oMResSchedule) const
	{ /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)oMResSchedule;
	}

	virtual tVoid vCopyRankListToFI(midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &oMRes) const
	{ /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)oMRes;
	}

	virtual tVoid vPrintRankList(midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &oMResSchedule) const
	{ /* Derived classes to Override this method*/
		//to solve prio2 lint info 715
		(tVoid)oMResSchedule;
	}

	virtual ~fc_sxm_tclNonTeamSports() { /*Implementation pending*/ }
private:
	tVoid vRetriveEventRankList(tU32 u32RootLeagueID, tU32 u32SubLeagueID , tBool bForSubLeague ,tU8 u8EventType, tS32 s32ParamIndex, tS32 s32TableRef);
	tVoid vExtractEventRankList(tVoid* pLeagueHandle, tS32 s32TableParam, tS32 s32TableRef);
};

#endif  /* _FC_SXM_TCL_SPORTS_NONTEAM_H_ */
