/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_manager.h
* @brief       Sports application manager
* 			   responsible for managing different sport objects.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_MANAGER_H_
#define FC_SXM_TCL_SPORTS_MANAGER_H_

#include "fc_sxm_tcl_sports_base.h"
#include "fc_sxm_tcl_sports_factory_interface.h"
#include "fc_sxm_tcl_singleton.h"
/******************************************
 * Class declarations
 *******************************************/
class fc_sxm_tclSportsManager :
	public fc_sxm_tclSingleton<fc_sxm_tclSportsManager>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclSportsManager>;
public:
	virtual ~fc_sxm_tclSportsManager();

	inline tBool bGetSportsListStatus() const { //Status whether sport and league list is available or not
		return _bSportsListStatus; }

	tVoid vSetSportsListStatus(tBool bStatus);

	//Methods utilised by sports app to retrieve and store sports list and league list
	tVoid vInitSportsManager();
	tVoid vDeInitSportsManager();

	//Method to Route Msg to corresponding Sport
	tVoid vRouteMsgToSport(fc_sxm_trMsgSportsSMSeLeagueCallback const *prMsg);

	tVoid vCreateSportsObject(fc_sxm_trSportsList& sportConfig);
	tVoid vBuildLeagueList(fc_sxm_trLeagueListData& league);
	tVoid vPrintSportsList() const;
	tVoid vPrintLeagueList() const;

	// Methods to send FI methodResults
	tVoid vSendSportsList(fc_sxm_trMsgSportsMStartGetSportList const *prMsg) const;
	tVoid vSendLeagueList(fc_sxm_trMsgSportsMStartGetRootAffiliateList const *prMsg) const;
	tVoid vSendAffiliateDetails(fc_sxm_trMsgSportsMStartGetAffiliateDetails const *prMsg);
	tVoid vSendAllTeams(fc_sxm_trMsgSportsMStartGetAllTeams const *prMsg);
	tVoid vSendGameList(fc_sxm_trMsgSportsMStartGetGameList const *prMsg);
	tVoid vSendScheduledEvents(fc_sxm_trMsgSportsMStartGetScheduledEvents const *prMsg);
	tVoid vSendEventRankList(fc_sxm_trMsgSportsMStartGetEventRankList const *prMsg);
	tVoid vSendNewsDetails(fc_sxm_trMsgSportsMStartGetNewsDetails const *prMsg);
	tVoid vClearSportsObjects(tVoid);

	/* Method to load from persistency class */
	tU32 u32LoadSportsList(tVoid);
	tVoid vLoadLeagueList(tVoid);
	/* Method to store to persistency class */
	tVoid vStoreSportsList(tVoid) const;
	tVoid vStoreLeagueList(tVoid) const;
	tVoid vCreateFavoriteLeagueList(tVoid) const;

	tBool bSetFavoriteTeam(tU8 u8SportId,tU32 u32LeagueId,tU32 u32TeamId) const;
	tVoid vRemoveLeagueRequests (tVoid) const;
	tVoid vClearLeagueData (tVoid) const;
	tVoid vSendTimeChange(tVoid) const;

	tU32 u32GetSportsObjectCount(tVoid) const;
	tVoid vNotifyLeagueUpdates (tVoid) const;

private:
	fc_sxm_tclSportsManager();
	tVoid vRemoveActiveRequest(tU8 u8SportID, tU32 u32LeagueID);
	tVoid vSendLeagueRequest(fc_sxm_trAdressing const &rAdressing);

private:
	tBool _bSportsListStatus;
	// mapping between SportsID with Sports Object Interface class
	map<tU8, fc_sxm_tclISportsBase*> _mapSportsObjects;
	fc_sxm_tclSportsIFactory* _poSportsFactory;
	tU8 _u8ActiveSportID;
	tU32 _u32ActiveRootLeagueID;
};


#endif /* FC_SXM_TCL_SPORTS_MANAGER_H_ */
