/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_fi_msgs.h
* @brief       Header file containing declarations for FI messages
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_FI_MSGS_H_
#define FC_SXM_TCL_SPORTS_FI_MSGS_H_

#include "fc_sxm_sports_fi.h"
#include "fc_sxm_tcl_sports_common.h"

/******************************************
 * Callbacks msgs from SMSe that needs to be handled by individual sport objects
 *******************************************/
struct fc_sxm_trMsgSportsSMSeLeagueCallback: public fc_sxm_tclMessage {
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 100);
	fc_sxm_trAdressing rAdressing;
	fc_sxmtrSMSeCallbackData SMSeCallbackData;
};

struct fc_sxm_trMsgSports: public fc_sxm_tclMessage {
	fc_sxm_trMsgSports(){
			//Inorder to avoid queuing with SMS messages
			//All Sports method start messages increased to high prio
			vSetMsgPrioHigh();
		}
};

/******************************************
 * Method-start from cca-service
 *******************************************/
struct fc_sxm_trMsgSportsMStartGetSportList: public fc_sxm_trMsgSports {
	//FI-msg methodStart for GetSportList
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 200);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetSportListMethodStart oFiMsg;
};

struct fc_sxm_trMsgSportsMStartGetRootAffiliateList: public fc_sxm_trMsgSports {
	//FI-msg methodStart for GetRootAffiliateList
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 201);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodStart oFiMsg;
};

struct fc_sxm_trMsgSportsMStartGetAffiliateDetails: public fc_sxm_trMsgSports {

	//FI-msg methodStart for GetAffiliateDetails
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 202);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodStart oFiMsg;
};

struct fc_sxm_trMsgSportsMStartGetAllTeams: public fc_sxm_trMsgSports {
	//FI-msg methodStart for Get All Teams
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 203);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodStart oFiMsg;
};
struct fc_sxm_trMsgSportsMStartGetGameList: public fc_sxm_trMsgSports {

	//FI-msg methodStart for Get Game List
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 204);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetGameListMethodStart oFiMsg;
};

struct fc_sxm_trMsgSportsMStartGetNewsDetails: public fc_sxm_trMsgSports {
	//FI-msg methodStart for GetNewsDetails
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 205);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodStart oFiMsg;
};
struct fc_sxm_trMsgSportsMStartGetScheduledEvents: public fc_sxm_trMsgSports {
	//FI-msg methodStart for Get Scheduled Events
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 206);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodStart oFiMsg;
};
struct fc_sxm_trMsgSportsMStartGetEventRankList: public fc_sxm_trMsgSports {
	//FI-msg methodStart for Get Event Rank List
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 207);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodStart oFiMsg;
};
struct fc_sxm_trMsgSportsMStartGetFavoriteList: public fc_sxm_trMsgSports {
	//FI-msg methodStart for GetFavoriteList
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 208);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgGetFavoritesMethodStart oFiMsg;
};
struct fc_sxm_trMsgSportsMStartSetAsFavorite: public fc_sxm_trMsgSports {
	//FI-msg methodStart for SetAsFavorite
	SXM_MAKE_ACTION(fc_sxm_enServiceID_Sports, 209);
	fc_sxm_trAdressing rAdressing;
	midw_ext_sxm_sportsfi_tclMsgSetAsFavoriteMethodStart oFiMsg;
};

#endif /* FC_SXM_TCL_SPORTS_FI_MSGS_H_ */
