/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_factory.h
* @brief       Sports factory class
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_FACTORY_H_
#define _FC_SXM_TCL_SPORTS_FACTORY_H_

#include "fc_sxm_tcl_sports_factory_interface.h"
#include "fc_sxm_tcl_singleton.h"
/*
 * Sports object factory declaration
 */
class fc_sxm_tclSportsFactory : public fc_sxm_tclSportsIFactory,
							public fc_sxm_tclSingleton<fc_sxm_tclSportsFactory>
{
	friend class fc_sxm_tclSingleton<fc_sxm_tclSportsFactory>;
public:
	fc_sxm_tclISportsBase* getSport(tU8 u8ID, tCString strName) const;

private:
	typedef enum enSportType
	{
		// enums used for identifying type of sport. Used by Factory to create objects
		fc_sxm_enSportType_TeamSports = 0x100,
		fc_sxm_enSportType_Golf = 0x101,
		fc_sxm_enSportType_MotorSport = 0x102,
		fc_sxm_enSportType_Other = 0x103
	} fc_sxm_tenSportType;

	//Logic for deciding the type of sports object to be created
	fc_sxm_tenSportType enGetSportType(tU8 u8ID, tCString strName) const;
	fc_sxm_tclISportsBase* poCreateSport( tU8 u8ID, tCString strName) const;
	tVoid vInitSport(fc_sxm_tclISportsBase* poSportObject, tU8 u8ID, tCString strName) const;

	tBool bIsSportSupported(tU8 u8ID) const;

	//Private constructor
	fc_sxm_tclSportsFactory();

private:
	const set <tU8> _setSupportedSports;
};

#endif  /* _FC_SXM_TCL_SPORTS_FACTORY_H_ */
