/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_base.h
* @brief       Sports Base
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_SPORTS_BASE_H_
#define _FC_SXM_TCL_SPORTS_BASE_H_

#include "fc_sxm_tcl_sports_base_interface.h"

//Request to pass to SMSe Callback
struct fc_sxm_trLeagueRequest
{
	tU8 u8SportID;
	tU32 u32LeagueID;
	tVoid* leagueHandle;
	fc_sxm_tclSportsAppIFace* poApp;
};

struct fc_sxmSportsDataUpdate{
	tU8 u8SportID;
	tU32 u32LeagueID ;
	tU8 u8UpdateStatus;
};
/*
 * Sports base class declaration
 */
class fc_sxm_tclSportsBase: public fc_sxm_tclISportsBase
{
public:

	//SMSe Methods
	/*final*/ tVoid vInitSport(tU8 u8ID, tCString strName);
	/*final*/ tVoid vSetObserver(fc_sxm_tclSportsAppIFace* poSportObserver);
	virtual tVoid vGetLeagueTree(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vGetAllTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing) const;
	virtual tVoid vGetSchedules(tU32 u32LeagueID,tU8 u8GameType,  tU32 u32GameID ,fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vGetEventRankList(tU32 u32LeagueID,tU8 u8GameType, tS32 s32ParamIndex, tS32 s32TableRef, fc_sxm_trAdressing const &rAdressing)
	{/* Derived classes to override this method*/
		(tVoid)u32LeagueID;
		(tVoid)u8GameType;
		(tVoid)s32ParamIndex;
		(tVoid)s32TableRef;
		(tVoid)rAdressing;
	}
	virtual tBool bIsScheduleAvilable(tU32 u32LeagueID, tU8 u8GameType) const;
	virtual tVoid vGetNewsItems(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing);
	virtual tVoid vGetTeamSchedules(tU32 u32LeagueID,tU32 u32TeamID,tU8 u8GameType,tU32 u32GameID , fc_sxm_trAdressing const &rAdressing)
	{ /* Derived classes to override this method */
		(tVoid)u32LeagueID;
		(tVoid)u32TeamID;
		(tVoid)u8GameType;
		(tVoid)u32GameID;
		(tVoid)rAdressing;
	}
	virtual tBool bSetFavoriteTeam(tU32 u32LeagueId,tU32 u32TeamId) const
	{ /* Derived classes to override this method */
		//to solve prio2 lint info 715
		(tVoid)u32LeagueId;
		(tVoid)u32TeamId;
		return FALSE;
	}

	//TODO: remove vPrintSportsDetails() and vPrintLeagues() once HMI flow is in place
	virtual tVoid vPrintSportsDetails() const;
	virtual tVoid vPrintLeagues() const;

	virtual tVoid vBuildLeagueList(fc_sxm_trLeagueListData &league) ;
	/*final*/ tU8 u8GetSportID() const;
	/*final*/ tCString sGetSportName() const;
	virtual tVoid vSendLeagueInfo(fc_sxm_trAdressing const &rAdressing) const;
	virtual tVoid vStoreLeagueInfo(tVoid) const;

	//Method to Handle SMSe Updates for a League
	virtual tVoid vHandleLeagueUpdates(fc_sxm_trMsgSportsSMSeLeagueCallback const *prMsg);
	virtual tVoid vEmit(tU32 u32GameID,fc_sxm_trAdressing const &rAdressing) { /* Please Over write this method */
			(tVoid)u32GameID;
			(tVoid)rAdressing;
	};
	virtual tVoid vRetrieveSchedules(tVoid* pLeagueHandle, tS32 s32TableParam);
	virtual tBool bExtractScheduleRow(tVoid* pHandle, SXMSportsRow &TableRow, tS32 s32TableParam , tU32 u32EpochValue, tBool bIsTeamBased)
	{ /* Derived classes to override this method */
		//to solve prio2 lint info 715
		(tVoid)pHandle;
		(tVoid)TableRow;
		(tVoid)s32TableParam;
		(tVoid)u32EpochValue;
		(tVoid)bIsTeamBased;
		return FALSE;
	}

	virtual tVoid vGetTopTeams(tU32 u32LeagueID, fc_sxm_trAdressing const &rAdressing)
	{ /* Derived classes to override this method */
		//to solve prio2 lint info 715
		(tVoid)u32LeagueID;
		(tVoid)rAdressing;
	}

	virtual tVoid vClearSchedulesList(){ /* Derived classes to override this method */}

	/*final*/ tVoid vRemoveLeagueRequests(tVoid) ;
	/*final*/ tVoid vResetLeagues();

	tVoid vNotifySportDataUpdate(tU32 u32TableLeague,tU8 u8UpdateType);
	
	static tU8 u8GetActiveScheduleType() {return _u8ScheduleType;}
	static tU16 u16GetActiveLeague() {return (tU16)_u32ActiveLeague;}
	tVoid vNotifyLeagueUpdates(tVoid) ;

public:
	fc_sxm_tclSportsBase() ;
	virtual ~fc_sxm_tclSportsBase();

protected:
	virtual tBool bIsAllTeamAvailable(tU32 ) const ;
	virtual tBool bIsRootAffiliate(tU32 u32LeagueID) const;
	virtual tU32 u32GetRootAffiliate(tU32 u32SubLeague) const;
	tBool bFindSchedule(tU8 u8GameType,tU8 u8ScheduleDay) const;
	tVoid vGetLeagueData(tU32 u32LeagueID,fc_sxm_trLeagueListData& trLeagueListData) const;
	tBool bHasSubLeagues(tU32 u32League,fc_sxm_trLeagueListData& trLeagueListData) const;
	virtual tBool bIsTeamSport() const { /* Derived classes to override this method */ return FALSE;}

	virtual tVoid vIgnoreUpdates(tBool bIgnore);
	virtual tVoid vSetCBAddress(tU32 u32LeagueID, fc_sxm_trAdressing const &rAddr) const;
	virtual tVoid vCreateLeagueRequest(tU32 u32LeagueID);
	fc_sxm_tenLeagueReqState enGetRequestState(tU32 u32LeagueID) const;

private:
	//Private member methods
	tVoid vSendLeagueTree(tU32 u32LeagueID) const;
	tVoid vFilterSchedules(
			tU32 u32RootLeagueID, tU32 u32SubLeagueID, tBool bForSubLeague,tU8 u8GameType);
	tBool bFilterSchedules(tU32 u32RootLeagueID, tU32 u32SubLeagueID, tBool bForSubLeague,tU8 u8GameType) const;
	tVoid vResetLeague(tU32 u32LeagueID);
	tVoid vBuildLeagueFamily(tU32 u32LeagueID);
	tBool bAddSubLeagues(fc_sxm_trLeagueListData &parent, fc_sxm_trLeagueListData &child);
	tBool bFindLeague(fc_sxm_trLeagueListData const& affiliate, tU32 u32LeagueID, fc_sxm_trLeagueListData& trLeagueListData)  const;
	tVoid vFillAffFixedList(tU32 u32LeagueID,midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult &oMRes) const;
	tVoid vPrintAffFixedList(midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult &oMRes) const;
	tVoid vFillSubLeagueList(fc_sxm_trLeagueListData const& affiliate, midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult &oMRes)  const;
	tBool u8IsDataAvailable(tU32 u32LeagueID,tU8 u8DataType) const;
	tVoid vAddTeams(tU32 u32LeagueID);
	tVoid vSetLeagueRequestStatus (tU32 u32LeagueID, fc_sxm_tenLeagueReqState enNewState);
	tVoid vSendLeagueTreeError(fc_sxm_trAdressing const &rAdressing) const;
	tU8 u8GetUpdateType(tU8 u8ScheduleDay) const;
	tBool bGetIgnoreUpdates()const;
	tBool bIsNewsAvailable(tU32 u32LeagueID) const;
	tVoid vSendNewsItems(tU32 u32LeagueID) const;
	tBool bValidateTable(tVoid* pLeagueHandle, tS32 s32TableParam) const;
	tU8 u8GetActiveUpdateType(tU8 u8UpdateType)const;
	tVoid vHandlePropertyUpdate(tU32 u32UpdateLeague , tU8 u8UpdateType ,tU8 u8UpdateStatus) ;
	tVoid vAccumulateLeagueUpdates(tU8 u8SportID, tU32 u32UpdateLeague , tU8 u8UpdateType , tU8 u8UpdateStatus);
	tVoid vRemoveExpiredTableParam(tS32 s32TableParam);

protected:
	tU8 _u8SPID; //sportID
	string _strSPName; //sportName

	//mapping between LeagueIDs and LeagueList ....
	map<tU32, fc_sxm_trLeagueListData> _mapLeague;

	//map to store League Specific Data
	map<tU32,fc_sxm_trLeagueData> _mapLeagueDetails;

	//vector to store the ActiveLeagueRequests
	vector<fc_sxm_trLeagueRequest*> _vectRequests;

	// app object acts as the observer for all sport objects
	fc_sxm_tclSportsAppIFace* _poApp;

	//League Iterator used to iterate through stored League Data
	typedef map<tU32,fc_sxm_trLeagueData>::iterator mapLeagueIter;

	tU32 _u32ActiveTeamID; //Active TeamID
	tU32 _u32FocussedGameID;

private:
	tBool _bIgnoreUpdate;
	 /*
	     we store a copy of Update Type because we must know, when there is an update from SXM.
	     notifications will only be sent if the timer expires */
	map<tU8 , fc_sxmSportsDataUpdate> _mapPropertyUpdate;
protected:
	//Private Member Data
	static tU32 _u32ActiveLeague;
	static fc_sxm_trAdressing _rMsgAdress;
	static tU8 _u8ScheduleType;
};

#endif /* FC_SXM_TCL_SPORTS_BASE_H_ */
