/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_sports_app_interface.h
* @brief       interface class for sports application.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_SPORTS_APP_INTERFACE_H_
#define FC_SXM_TCL_SPORTS_APP_INTERFACE_H_

#include "fc_sxm_types.h"

// Forward declarations
class midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult;
class midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult;
struct fc_sxm_trMsgSportsSMSeLeagueCallback;


class fc_sxm_tclSportsAppIFace {
public:
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetAffiliateDetailsMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetRootAffiliateListMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetAllTeamsMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetNewsDetailsMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetGameListMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetScheduledEventsMethodResult &) = 0;
	virtual tVoid vSendFiMsg(fc_sxm_trAdressing const  &, const midw_ext_sxm_sportsfi_tclMsgGetEventRankListMethodResult &) = 0;
	virtual tVoid vSendErrorMsg(fc_sxm_trAdressing const  &, tInt) = 0;

	virtual tVoid vSendSportsDataUpdateStatus(tU8 u8SportID, tU32 u32LeagueID , tU8 u8UpdateType ,tU8 u8UpdateStatus) const = 0;
	
	virtual tVoid vStartSportsTimer(tU32 msecDuration) = 0;
	virtual tBool bIsSportsTimerRunning(tVoid) const = 0;
	
	virtual tVoid vPostInternalMsg(const fc_sxm_trMsgSportsSMSeLeagueCallback & ) = 0;
	virtual const tChar* pGetTimeZone() = 0;
	virtual tBool bGetClockDST()const = 0;
	virtual tU8 u8GetDayMapIndex(tU32) const = 0;

    virtual ~fc_sxm_tclSportsAppIFace() {}

};


#endif /* FC_SXM_TCL_SPORTS_APP_INTERFACE_H_ */
