/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_proxy_if.h
* @brief       Interface for Phonetics class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PHONETICS_PROXY_IF_H
#define FC_SXM_TCL_PHONETICS_PROXY_IF_H

#include "fc_sxm_types.h"
#include "fc_sxm_sms.h"

class Ifc_sxm_tclPhoneticsProxy
{
public:
    virtual ~Ifc_sxm_tclPhoneticsProxy() { /* Default DTOR */ }
    virtual PHONETICS_SERVICE_OBJECT vStartSmsService(const char *pacSRHDriverName,
            const char *pacOutputDir,
            DATASERVICE_EVENT_MASK tEventRequestMask,
            DATASERVICE_EVENT_CALLBACK vEventCallback,
            void *pvEventCallbackArg,
            PHONETICS_FILE_UPDATE_CALLBACK vFileCallback,
            void *pvFileCallbackArg,
            DATASERVICE_OPTIONS_STRUCT const *psOptions
    ) = 0;
    virtual tBool bGenerateBaselineFile() = 0;
    virtual SERVICE_ID hReadServiceIdFromDictionary(OSAL_FILE_STRUCT *) = 0;

    virtual int iFclose(OSAL_FILE_STRUCT *psDictionaryFile)= 0;
    virtual OSAL_FILE_STRUCT* psFopen(const char *pacDictionaryPath, const char *pcMode)= 0;
    virtual int iFgetc(OSAL_FILE_STRUCT *psFile)= 0;
    virtual tSize tFread(void *pvDst, tSize size, tSize tNumObj, OSAL_FILE_STRUCT *psFile)= 0;

};

#endif // FC_SXM_TCL_PHONETICS_PROXY_IF_H
