/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_fi_msgs.h
* @brief       Declarations for FI messages for Phonetics service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PHONETICS_FI_MSGS_H_
#define FC_SXM_TCL_PHONETICS_FI_MSGS_H_

#include "fc_sxm_phonetics_fi.h"
#include "fc_sxm_types.h"

/******************************************
 * Callbacks msgs from SMSe that needs to be handled by individual phonetics objects
 *******************************************/
struct fc_sxm_trMsgPhoneticsSMSFileEventCallback: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Phonetics, 100);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus oFiMsg;
};


/******************************************
 * Method-start from cca-service
 *******************************************/

struct fc_sxm_trMsgDataMStartGetPhoneticsData
: public fc_sxm_tclMessage
  {
    /* Service and service ID */
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Phonetics, 200);
    /* Re-addressing info */
    fc_sxm_trAdressing rAdressing;
    /* Method start request */
    midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodStart oFiMsg;
  };


#endif /* FC_SXM_TCL_PHONETICS_FI_MSGS_H_ */
