/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_phonetics_base.h
* @brief       Base class declaration for Phonetics service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PHONETICS_DATA_BASE_H_
#define _FC_SXM_TCL_PHONETICS_DATA_BASE_H_

#include "fc_sxm_tcl_phonetics_base_if.h"

class Ifc_sxm_tclPhoneticsProxy;

//Class Declaration
class fc_sxm_tclPhoneticsBase : public fc_sxm_tclIPhoneticsBase
{
public:

    /* Constructor */
    fc_sxm_tclPhoneticsBase();
    fc_sxm_tclPhoneticsBase(Ifc_sxm_tclPhoneticsProxy *pIPhoneticsProxy);

    // Destructor
    virtual ~fc_sxm_tclPhoneticsBase();

    //
    virtual tVoid vConvertPhoneticsInfo(midw_ext_sxm_phoneticsfi_tclMsgPhoneticsUpdateStatus &oFiMsg);

    //phonetics files path set method
    virtual tVoid vGetPhoneticsData(midw_ext_sxm_phoneticsfi_tclMsgGetPhoneticsDataMethodResult &ofiTxObj);

    //phonetics string parser method
    virtual tBool bReadPhoneticEntry (OSAL_FILE_STRUCT *psPhoneticsFile, vector<midw_ext_fi_tclString> &vChannelString);

protected:
#ifdef UNITTEST_FC_SXM
    // For unit test product, to perform effective unit-testing of all private members,
    // the private methods/variables are made public.
    // In production-code, the methods and variables still remain private
public:
#endif
    Ifc_sxm_tclPhoneticsProxy* _poPhoneticsProxy;

private:
#ifdef UNITTEST_FC_SXM
    // For unit test product, to perform effective unit-testing of all private members,
    // the private methods/variables are made public.
    // In production-code, the methods and variables still remain private
public:
#endif

    //convert SMS file type to local file type
    tU8 u8GetPhoneticsFileType(tU8 eFileType);

    //convert SMS language type to local language type
    tU8 u8GetPhoneticsLanguageType(tU8 eLangType);

    tBool bIsDelimeter(const char cChar);

    tBool bIsEndOfLine(const char cChar);

    tBool bAddPhoneticsIntoList(char* pcBuffer, UN8 &un8Index,
            vector<midw_ext_fi_tclString> &vPhoneticsString);

};

#endif //_FC_SXM_TCL_PHONETICS_DATA_BASE_H_
