/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_sdk_proxy_if.h
* @brief       Parking Proxy interface for SMSe APIs
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_SDK_PROXY_IF_H_
#define _FC_SXM_TCL_PARKING_SDK_PROXY_IF_H_

#include "fc_sxm_types.h"
#include "fc_sxm_smse.h"

//Class Declaration
class fc_sxm_tclIParkingSdkProxy
{
public:

    // Service related API's
    virtual tS32 s32StartService(void (*callback)(int, int), int debug) const = 0;
    virtual tS32 s32ServiceStatus(SXMStatus* status) const = 0;
    virtual tS32 s32StopService() const = 0;

    //Collection related API's
    virtual tS32 s32StartRequest(SXMMBR *mbr, SXMPoint *center, void (*callback)(ptr, ptr), ptr usercx, ptr *handle) const = 0;
    virtual tS32 s32ModifyRequest(ptr handle, SXMMBR *mbr, SXMPoint *center) const = 0;
    virtual tS32 s32RemoveCollection(ptr handle) const = 0;

    // Extraction Interface related API's
    virtual tS32 s32BeginExtraction(ptr handle, SXMPoint *center) const = 0;
    virtual tS32 s32ExtractParkingLocation(ptr handle, SXMParkingLocation *pl) const = 0;
    virtual tS32 s32EndExtraction(ptr handle) const = 0;

    // Interfaces related to PPOI
    virtual tS32 s32POIBeginExtraction(const SXMMBR *mbr, ushort filterMask) const = 0;
    virtual tS32 s32POIExtractParkingLocation(SXMParkingLocation *pLocation) const = 0;
    virtual tS32 s32POIEndExtraction() const = 0;
    virtual tS32 s32SetPPOIList(const uint specCnt, const PPOISpec *specs ,
            void (*notification)(ptr, byte), ptr usercx) const = 0;


    // Utility methods
    virtual tF32 f32GetClosestPoint(SXMPoint *sort) const = 0;
    virtual tF32 f32GetFarthestPoint(SXMPoint *sort) const = 0;

    virtual ~fc_sxm_tclIParkingSdkProxy() { }
};

#endif //_FC_SXM_TCL_PARKING_SDK_PROXY_IF_H_
