/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_sdk_proxy.h
* @brief       Header file which acts as interface between fc_sxm app
*              and SMS library for Parking specific calls.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_SDK_PROXY_H_
#define FC_SXM_TCL_PARKING_SDK_PROXY_H_

#include "fc_sxm_tcl_parking_sdk_proxy_if.h"

class fc_sxm_tclParkingSdkProxy :
public fc_sxm_tclIParkingSdkProxy,
public fc_sxm_tclSingleton<fc_sxm_tclParkingSdkProxy>
{
public:
    virtual ~fc_sxm_tclParkingSdkProxy() ;

    // Service related API's
    virtual tS32 s32StartService(void (*callback)(int, int), int debug) const;
    virtual tS32 s32ServiceStatus(SXMStatus* status) const;
    virtual tS32 s32StopService() const;

    //Collection related API's
    virtual tS32 s32StartRequest(SXMMBR *mbr, SXMPoint *center, void (*callback)(ptr, ptr), ptr usercx, ptr *handle) const;
    virtual tS32 s32ModifyRequest(ptr handle, SXMMBR *mbr, SXMPoint *center) const;
    virtual tS32 s32RemoveCollection(ptr handle) const;

    // Extraction Interface related API's
    virtual tS32 s32BeginExtraction(ptr handle, SXMPoint *center) const;
    virtual tS32 s32ExtractParkingLocation(ptr handle, SXMParkingLocation *pl) const;
    virtual tS32 s32EndExtraction(ptr handle) const;

    // POI related API's
    virtual tS32 s32POIBeginExtraction(const SXMMBR *mbr, ushort filterMask) const;
    virtual tS32 s32POIExtractParkingLocation(SXMParkingLocation *pLocation) const;
    virtual tS32 s32POIEndExtraction() const;
    virtual tS32 s32SetPPOIList(const uint specCnt, const PPOISpec *specs ,
            void (*notification)(ptr, byte), ptr usercx) const;

    // Utility methods
    virtual tF32 f32GetClosestPoint(SXMPoint *sort) const;
    virtual tF32 f32GetFarthestPoint(SXMPoint *sort) const;
private:
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingSdkProxy>;
    fc_sxm_tclParkingSdkProxy();
};


#endif /* FC_SXM_TCL_PARKING_SDK_PROXY_H_ */
