/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_properties.h
* @brief       header file to hold all properties declrations used in parking service.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_PROPERTIES_H
#define FC_SXM_TCL_PARKING_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_parking_fi.h"

/*
  Semaphore-protected data of parking-app
 */

// example for property, where fi-type is stored directly in member "oFiMsg"

struct fc_sxm_tcl_trParkingPropertyServiceDataStatus {
    fc_sxm_tcl_trParkingPropertyServiceDataStatus()
    { /** Default constructor **/ }

    bool operator!=(fc_sxm_tcl_trParkingPropertyServiceDataStatus const& b) const
		        {
        /** Overloaded "!=" operator**/
        return !(oFiMsg==b.oFiMsg);
		        }
    midw_ext_sxm_parkingfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
};

// Added for the Property ParkingDataUpdate

struct fc_sxm_tcl_trParkingPropertyDataUpdate {
    fc_sxm_tcl_trParkingPropertyDataUpdate()
    { /** Default constructor **/ }

    bool operator!=(fc_sxm_tcl_trParkingPropertyDataUpdate const& b) const
    	        {
        /** Overloaded "!=" operator**/
        return !(oFiMsg==b.oFiMsg);
    	        }
    midw_ext_sxm_parkingfi_tclMsgParkingInfoListsStatusStatus oFiMsg;
};

struct fc_sxm_tcl_trParkingPropertySxmListMode {
	fc_sxm_tcl_trParkingPropertySxmListMode()
    { /** Default constructor **/ }

    bool operator!=(fc_sxm_tcl_trParkingPropertySxmListMode const& b) const
    	        {
        /** Overloaded "!=" operator**/
        return !(oFiMsg==b.oFiMsg);
    	        }
    midw_ext_sxm_parkingfi_tclMsgSxmListModeStatus oFiMsg;
};
class fc_sxm_tclParkingProperties:
public fc_sxm_tclSingleton<fc_sxm_tclParkingProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingProperties>;
public:
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trParkingPropertyServiceDataStatus,
    CCA_C_U16_SRV_SXM_PARKING, /*the service-id of the CCA-Service */
    MIDW_EXT_SXM_PARKINGFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
    > oParkingServiceDataStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trParkingPropertyDataUpdate,
    CCA_C_U16_SRV_SXM_PARKING, /*the service-id of the CCA-Service */
    MIDW_EXT_SXM_PARKINGFI_C_U16_PARKINGINFOLISTSSTATUS /* give FID if notification to service is needed  */
    > oParkingDataUpdateStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trParkingPropertySxmListMode,
    CCA_C_U16_SRV_SXM_PARKING, /*the service-id of the CCA-Service */
	MIDW_EXT_SXM_PARKINGFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
    > oSxmListMode;
};

#endif
