/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_manager_if.h
* @brief       interface class for parking manager.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_MANAGER_IF_H_
#define FC_SXM_TCL_PARKING_MANAGER_IF_H_

#include "fc_sxm_types.h"

//forward declaration
class fc_sxm_tclIParkingApp;
class fc_sxm_tclIParkingSdkProxy;
class fc_sxm_tclIParkingBase;
class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart;
class midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart;

/******************************************
 * Class declarations
 *******************************************/
class fc_sxm_tclIParkingManager
{

public:
    virtual tVoid vInitParkingManager(fc_sxm_tclIParkingApp* poApp,fc_sxm_tclIParkingSdkProxy* poSDKProxy) = 0;
    virtual tVoid vDeInitParkingManager() = 0;
    virtual tVoid vCreateParkingList() = 0;
    virtual fc_sxm_tclIParkingBase* poGetListByID(tU8 u8ListID) const = 0;
    virtual tVoid vRemoveRequests() const = 0;
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart &oMStart) const = 0;

    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart &oMStart) const = 0;
    virtual ~fc_sxm_tclIParkingManager() { }
};


#endif /* FC_SXM_TCL_PARKING_MANAGER_IF_H_ */
