/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_manager.h
* @brief       class to manage parking list objects.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_MANAGER_H_
#define FC_SXM_TCL_PARKING_MANAGER_H_

#include "fc_sxm_tcl_parking_manager_if.h"

//forward declration
class fc_sxm_tclIParkingFactory;

/******************************************
 * Class declarations
 *******************************************/
class fc_sxm_tclParkingManager :
    public fc_sxm_tclIParkingManager,
    public fc_sxm_tclSingleton<fc_sxm_tclParkingManager>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingManager>;
public:
    virtual ~fc_sxm_tclParkingManager();

    //Methods utilised by parking app to retrieve and store parking list and league list
    virtual tVoid vInitParkingManager(fc_sxm_tclIParkingApp* poApp,fc_sxm_tclIParkingSdkProxy* poSDKProxy);
    virtual tVoid vDeInitParkingManager();

    virtual tVoid vCreateParkingList();
    virtual tVoid vRemoveRequests() const;
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart &oMStart) const;
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart &oMStart) const;
    virtual fc_sxm_tclIParkingBase* poGetListByID(tU8 u8ListID) const;

private:
    fc_sxm_tclParkingManager();
    tVoid vClearParkingList();

private:
    // mapping between ListID with Parking Object Interface class
    map<tU8, fc_sxm_tclIParkingBase*> _mapParkingList;
    fc_sxm_tclIParkingFactory* _poParkingFactory;
    fc_sxm_tclIParkingApp* _poParkingApp;
    fc_sxm_tclIParkingSdkProxy* _poSDKProxy;
};


#endif /* FC_SXM_TCL_PARKING_MANAGER_H_ */
