/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_filterconfig.h
* @brief       Class to handle filter configuration from HMI
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_FILTERCONFIG_H_
#define _FC_SXM_TCL_PARKING_FILTERCONFIG_H_

//#include "fc_sxm_types.h"
#include "fc_sxm_parking_fi.h"

//Class Declaration
class fc_sxm_trParkingFilterConfig
{

public:
    //Constructor
    fc_sxm_trParkingFilterConfig();
    //destructor
    virtual ~fc_sxm_trParkingFilterConfig();

    //method to check if parking location can be filtered
    tBool bFilterParkingStation(fc_sxm_trParkingFilterConfig &smsParkingLoc);

    tBool bIsParkingStationAllowed(midw_ext_fi_tcl_AmenityInfo &oAmenInfo,midw_ext_fi_tcl_e8OpenStatus &enOpenStatus,tU32 u32Height);

    //method to set filter configuration from HMI
    tVoid vSetFilterConfig(midw_ext_fi_tcl_e8CashOrCard enCash,
            midw_ext_fi_tcl_e8CashOrCard enCard,
            midw_ext_fi_tcl_e8SelfParking enSelfParking,
            midw_ext_fi_tcl_e8ParkingType enParkingType,
            midw_ext_fi_tcl_e8OpenStatus enOpenStatus,
            midw_ext_fi_tcl_e8SUVCharges enSUVCharges,
            tU32 u32Height
            );
    //method to set filter configuration from HMI
    tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart &oMStart);
			
private:
    tVoid vClearMemberData();

    //Util functions to Check all Amenety fileds from HMI
    tBool bCheckOpen24Hours(midw_ext_fi_tcl_e8Open24Hours& enOpen24Hours);
    tBool bCheckCash(midw_ext_fi_tcl_e8CashOrCard& enCash);
    tBool bCheckCard(midw_ext_fi_tcl_e8CashOrCard& enCard);
    tBool bCheckParkingType(midw_ext_fi_tcl_e8ParkingType& enParkingType);
    tBool bCheckMetroLocation(midw_ext_fi_tcl_e8MetroLocation& enMetroLocation);
    tBool bCheckAirPort(midw_ext_fi_tcl_e8AirPort& enAirPort);
    tBool bCheckOvernightParking(midw_ext_fi_tcl_e8OvernightParking& enOvernightParking);
    tBool bCheckReservations(midw_ext_fi_tcl_e8Reservations& enReservations);
    tBool bCheckSelfParking(midw_ext_fi_tcl_e8SelfParking& enSelfParking);
    tBool bCheckSecurity(midw_ext_fi_tcl_e8Security& enSecurity);
    tBool bCheckTollTag(midw_ext_fi_tcl_e8TollTag& enTollTag);
    tBool bCheckSUVCharges(midw_ext_fi_tcl_e8SUVCharges& enSUVCharges);
    tBool bCheckRV(midw_ext_fi_tcl_e8RV& enRV);

    //Util functions to check other paramentes from HMI
    tBool bCheckOpenStatus(midw_ext_fi_tcl_e8OpenStatus &enOpenStatus);
    tBool bCheckLocationHeight(tU32 u32Height);

private:
    midw_ext_fi_tcl_e8CashOrCard _enCash;
    midw_ext_fi_tcl_e8CashOrCard _enCard;
    midw_ext_fi_tcl_e8SelfParking _enSelfParking;
    midw_ext_fi_tcl_e8ParkingType _enParkingType;
    midw_ext_fi_tcl_e8OpenStatus _enOpenStatus;
    midw_ext_fi_tcl_e8SUVCharges _enSUVCharges;
    midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart _oFilterConfig;
    tU32 _u32Height;

};


#endif //_FC_SXM_TCL_PARKING_FILTERCONFIG_H_
