/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_fi_msgs.h
* @brief       Header file containing declarations for FI messages
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_PARKING_FI_MSGS_H_
#define FC_SXM_TCL_PARKING_FI_MSGS_H_

#include "fc_sxm_parking_fi.h"
#include "fc_sxm_types.h"

/******************************************
 * Callbacks msgs from SMSe that needs to be handled by individual parking locations
 *******************************************/
struct fc_sxm_trMsgParkingSMSeRequestCallback: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 100);
    fc_sxm_trAdressing rAdressing;
};
struct fc_sxm_trMsgParkingSMSePOICallback: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 101);
    fc_sxm_trAdressing rAdressing;
    tU32 u32FilterMask;
};

/******************************************
 * Method-start from cca-service
 *******************************************/
struct fc_sxm_trMsgParkingMStartGetParkingList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartSetParkingFilterConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 201);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartGetParkingInfo: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 202);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgGetParkingStationInfoMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartSaveParkingID: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 203);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgAddFavoriteMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartRemoveParkingID: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 204);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgRemoveFavoriteMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartRestoreFavorites: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 205);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgRestoreFavoritesMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingMStartSetParkingFilterConfiguration: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 206);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart oFiMsg;
};
struct fc_sxm_trMsgParkingPSetListMode: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 207);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_parkingfi_tclMsgSxmListModeSet oFiMsg;
};
#endif /* FC_SXM_TCL_PARKING_FI_MSGS_H_ */
