/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_favorites.cpp
* @brief       Class to handle Favorites Parking Data
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_tcl_parking_favorites.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_sxm_trace_macros.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_PARKING_FAVORITES
#include "trcGenProj/Header/fc_sxm_tcl_parking_favorites.cpp.trc.h"
#endif

/****************************************************************************
 *
 *FUNCTION:          fc_sxm_tclParkingFavorites
 *
 *DESCRIPTION:       Constructor
 *
 *PARAMETERS:       None
 *
 *RETURNVALUES:      None
 *
 ******************************************************************************/
fc_sxm_tclParkingFavorites::fc_sxm_tclParkingFavorites()
{
    ETG_TRACE_USR4(("fc_sxm_tclParkingFavorites constructor"));
    _u32ListID = (tU32)midw_ext_fi_tcl_e8_SxmListType::FI_EN_FAVORITE;
    _u16FilterMask = FC_SXM_PARKING_FAV_FILTER_MASK;
    _u32CurrentOrder = 0;
}
/****************************************************************************
 *
 *FUNCTION:          ~fc_sxm_tclParkingFavorites
 *
 *DESCRIPTION:       Destructor
 *
 *PARAMETERS:       None
 *
 *RETURNVALUES:      None
 *
 ******************************************************************************/
fc_sxm_tclParkingFavorites::~fc_sxm_tclParkingFavorites()
{
    ETG_TRACE_USR4(("fc_sxm_tclParkingFavorites destructor"));
    _u32CurrentOrder = 0;
}
/****************************************************************************
 *
 *FUNCTION:          vAddFavorite
 *
 *DESCRIPTION:       to add particular parkingID to favorite list
 *
 *PARAMETERS:        parkingID
 *
 *RETURNVALUES:      None
 *
 ******************************************************************************/
tBool  fc_sxm_tclParkingFavorites::bAddFavorite(tU32 u32ParkingID)
{
    ETG_TRACE_USR4(("fc_sxm_tclParkingFavorites::bAddFavorite map size=%d,FilterMask=%d",_mapPOIList.size(),_u16FilterMask));

    tBool bExists = FALSE;
    SXM_IF_FIND_MAP(tU32,trPOIData,iter,_mapPOIList,u32ParkingID)
    {
        bExists = TRUE;
    }
    if(!bExists)
    {
        trPOIData rPOIData;
        rPOIData.u32Index = ++_u32CurrentOrder;
        rPOIData.u16Userflag = _u16FilterMask;

        _mapPOIList.insert(pair<tU32,trPOIData>(u32ParkingID,rPOIData));

        return TRUE;
    }
    else
    {
        ETG_TRACE_USR4(("bAddFavorite u32ParkingID=%d already exists in favorite list",u32ParkingID));
    }

    return FALSE;
}
/****************************************************************************
 *
 *FUNCTION:          vAddFavorite
 *
 *DESCRIPTION:       to remove particular parkingID from favorite list
 *
 *PARAMETERS:        parkingID
 *
 *RETURNVALUES:      None
 *
 ******************************************************************************/
tBool  fc_sxm_tclParkingFavorites::bRemoveFavorite(tU32 u32ParkingID)
{
    ETG_TRACE_USR4(("fc_sxm_tclParkingFavorites::vRemoveFavorite START map size=%d",_mapPOIList.size()));

    tBool bStatus = FALSE;
    SXM_IF_FIND_MAP(tU32,trPOIData,iter,_mapPOIList,u32ParkingID)
    {
        _mapPOIList.erase(iter);
        bStatus = TRUE;
    }
    ETG_TRACE_USR4(("fc_sxm_tclParkingFavorites::vRemoveFavorite End map size=%d",_mapPOIList.size()));
    return bStatus;
}
/****************************************************************************
 *
 *FUNCTION:          vClearPOIUserFlag
 *
 *DESCRIPTION:       to clear particular Parking user flag
 *
 *PARAMETERS:        u32ParkingID
 *
 *RETURNVALUES:      None
 *
 ******************************************************************************/
tVoid fc_sxm_tclParkingFavorites::vClearPOIUserFlag(tU32 u32ParkingID)
{
    SXM_IF_FIND_MAP(tU32,trPOIData,FavIter,_mapPOIList,u32ParkingID)
    {
        //OK,just clear favorite flag
        ETG_TRACE_USR4(("Clearing Fav bit for ParkingID=%d,old flag=%d",FavIter->first,FavIter->second.u16Userflag));
        FavIter->second.u16Userflag = FavIter->second.u16Userflag & FC_SXM_PARKING_NO_FILTER;
        ETG_TRACE_USR4(("Cleared Fav bit for ParkingID=%d,new flag=%d",FavIter->first,FavIter->second.u16Userflag));
    }
}
