/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_base.h
* @brief       base class header for parking list.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_LIST_BASE_H_
#define _FC_SXM_TCL_PARKING_LIST_BASE_H_

#include "fc_sxm_tcl_parking_base_if.h"
#include "fc_sxm_tcl_parking_filterconfig.h"

//Class Declaration
class fc_sxm_tclParkingBase : public fc_sxm_tclIParkingBase
{
public:

    /* Constructor */
    fc_sxm_tclParkingBase();

    // Destructor
    virtual ~fc_sxm_tclParkingBase();

    /*final*/ tVoid vSetApp(fc_sxm_tclIParkingApp *,fc_sxm_tclIParkingSdkProxy*);

    //Set SXM position as per lat & lon
    virtual tVoid vSetPosition(tS32 s32Lon,tS32 s32Lat);

    //Prepare MBR on position set
    virtual tVoid vPrepareMBR();

    //Remove the Request
    virtual tVoid vRemoveRequest();

    // Start the Request
    virtual tVoid vStartRequest();

    //To get full parking List
    virtual tS32 s32GetParkingList(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult &);

    //to get particular parking location
    virtual tS32 s32GetParkingInfo(tU32,midw_ext_fi_tcl_ParkingInfo &);

    //Set Filter configuration as per HMI
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigMethodStart &);

    //Set Filter configuration as per HMI
    virtual tVoid vSetFilterConfig(const midw_ext_sxm_parkingfi_tclMsgSetFilterConfigurationMethodStart &);

    //to set new POI list as PPOI's
    virtual tS32 s32SetPPOIList(vector<PPOISpec>&);

    virtual tS32 s32RefreshPOIList()
    {
        //to be implemente by derived classes
        return SXM_E_ERROR;
    }

    virtual tVoid vClearPPOIUserFlag() {}

    virtual tBool bAddFavorite(tU32) { return FALSE;}
    virtual tBool bRemoveFavorite(tU32) { return FALSE; }

    //for debugging purpose only
    virtual tVoid vPrintParkingList(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult &) const;
    virtual tVoid vPrintParkingInfo(midw_ext_fi_tcl_ParkingInfo &rParkingInfo) const;

    virtual tU32 u32GetListID() const
    {
        return _u32ListID;
    }

    virtual const map<tU32,trPOIData>& mapGetPOIList() const
    {
        return _mapPOIList;
    }
    virtual tVoid vClearPOIList()
    {
        _mapPOIList.clear();
    }
    virtual tVoid vClearPOIUserFlag(tU32) {};

    virtual tVoid vSetListMode(const midw_ext_fi_tcl_e8_SxmListMode&);

    virtual const midw_ext_fi_tcl_e8_SxmListMode& trGetListMode()
    {
    	return _trListMode;
    }

protected:
    //Clear member variables
    tVoid vClearMemberData();

    //copy particular location to FI
    tVoid vCopyLocationToFI(SXMParkingLocation&,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;

    //Method to copy fullness details to FI
    tVoid vCopyFullness(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;

    //Methods to copy fillness values for each 15mins
    tBool bCopyFullnessNow(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    tBool bCopyFullness15Min(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    tBool bCopyFullness30Min(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    tBool bCopyFullness45Min(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    tBool bCopyFullness60Min(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;

    //Method to copy fullness details to FI
    tVoid vCopyAmenities(tU32 u32SDKAmen,midw_ext_fi_tcl_AmenityInfo& rAmenInfo) const;

    //Method to copy price details to FI
    tVoid vCopyPricing(SXMParkingLocation& rLocation,midw_ext_fi_tcl_PriceInfo& rPricingInfo) const;

    //method to copy Opening time details to FI
    tVoid vCopyOpeningTimes(SXMParkingLocation& rLocation,midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    tVoid vGetOpeningTime(string& strParkingTime,string& strTimeHrs,string &strTimeMts) const;

    //function to return
    tU32 u32GetAmenValue(tU32 u32Val,tU8 u8Pos) const;

    tBool bIsFilterLocation(SXMParkingLocation &rLocation);

    midw_ext_fi_tcl_e8OpenStatus::tenType enGetOpenStatus(midw_ext_fi_tcl_ParkingInfo& rParkingInfo) const;
    midw_ext_fi_tcl_e8OpenStatus::tenType enFindOpenStatus(tBool bIsClosed,tBool bIsOpen,tBool bIsMorethanStartTime,tBool bIsLessThanEndTime) const;
    tBool bCheckOpen24Hours(
            tU32 u32StartTimeinHrs,tU32 u32StartTimeinMts,tU32 u32EndTimeinHrs,tU32 u32EndTimeinMts) const;
    tBool bCheckClosedStatus(
            tU32 u32StartTimeinHrs,tU32 u32StartTimeinMts,tU32 u32EndTimeinHrs,tU32 u32EndTimeinMts) const;
    tBool bCheckStartTime(tU32 u32StartTimeinHrs,tU32 u32StartTimeinMts) const;
    tBool bCheckEndTime(tU32 u32StartTimeinHrs,tU32 u32StartTimeinMts,tU32 u32EndTimeinHrs,tU32 u32EndTimeinMts) const;

protected:

    //SXM Position Point
    SXMPoint _rSXMPoint;

    //SXM MBR rectangle
    SXMMBR _rSXMMbr;

    //handle to hold active request
    tVoid* _pReqHandle;

    fc_sxm_tclIParkingApp* _poApp;
    fc_sxm_tclIParkingSdkProxy* _poProxy;

    fc_sxm_trParkingFilterConfig _FilterConfig;

    ushort _u16FilterMask;

    tU32 _u32ListID;

    map<tU32,trPOIData> _mapPOIList;

    midw_ext_fi_tcl_e8_SxmListMode _trListMode;

};

#endif //_FC_SXM_TCL_PARKING_LIST_BASE_H_
