/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_app_if.h
* @brief       interface class for parking app handler
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_APP_IF_H_
#define _FC_SXM_TCL_PARKING_APP_IF_H_

#include "fc_sxm_types.h"

//forward declaration
struct fc_sxm_trMsgParkingSMSeRequestCallback;
struct fc_sxm_trMsgParkingSMSePOICallback;

//Class Declaration
class fc_sxm_tclIParkingApp {
public:

    virtual tVoid vPostInternalMsg(const fc_sxm_trMsgParkingSMSeRequestCallback & ) = 0;
    virtual tVoid vPostInternalMsg(const fc_sxm_trMsgParkingSMSePOICallback & ) = 0;

    virtual tBool bIsFavorite(tU32 u32ParkingID) const = 0;

    virtual tF32 f32GetDistanceFromDestination(tF32 f32Lat,tF32 f32Lon) = 0;
    virtual tF32 f32GetCurrentDistance(tS32 s32Lat,tS32 s32Lon) = 0;
    virtual tF32 f32GetDistanceFromFrozenDevicePos(tF32 f32Lat,tF32 f32Lon) = 0;

    virtual tU32 u32GetCapacity(tU32) const = 0;
    virtual tF32 f32GetRadius(tU32) const = 0;
    virtual tU8 u8GetCurentWeekDay() const = 0;
    virtual tU8 u8GetCurentHour() const = 0;
    virtual tU8 u8GetCurentMinutes() const = 0;

	virtual tVoid vStartListTimer(tU32 u32ListID) = 0;
	virtual tVoid vStopListTimer(tVoid) = 0;

	virtual tVoid vFreezeDevicePosition() = 0;
	virtual tVoid vReleaseDevicePosition() = 0;

	virtual tVoid vSendUpdate(tU32) = 0;

    virtual ~fc_sxm_tclIParkingApp() {}

};


#endif //_FC_SXM_TCL_PARKING_APP_IF_H_
