/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_parking_app.h
* @brief       Parking application handler header file
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_PARKING_APP_H_
#define _FC_SXM_TCL_PARKING_APP_H_

#include "fc_sxm_tcl_data_app.h"
#include "fc_sxm_types.h"
#include "fc_sxm_tcl_parking_app_if.h"

//Forward Declarations
struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclIParkingSdkProxy;
struct fc_sxm_trMsgParkingSMSeRequestCallback;
struct fc_sxm_trMsgParkingMStartGetParkingList;
struct fc_sxm_trMsgParkingMStartSetParkingFilterConfig;
struct fc_sxm_trMsgParkingMStartSetParkingFilterConfiguration;
struct fc_sxm_trMsgParkingMStartGetParkingInfo;
struct fc_sxm_trMsgParkingMStartSaveParkingID;
struct fc_sxm_trMsgParkingMStartRemoveParkingID;
struct fc_sxm_trMsgParkingMStartRestoreFavorites;
struct fc_sxm_trMsgParkingPSetListMode;
class fc_sxm_tclIParkingManager;
class midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult;

struct fc_sxm_trMsgParkingListUpdateTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Parking, 208);
    tU32 u32ListID;
};

//Class Declaration
class fc_sxm_tclParkingApp :
public fc_sxm_tclIParkingApp,
public fc_sxm_tclDataApp,
public fc_sxm_tclSingleton<fc_sxm_tclParkingApp>

{

    friend class fc_sxm_tclSingleton<fc_sxm_tclParkingApp>;

public:

    //Service ID for Parking
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Parking;

    // Destructor
    virtual ~fc_sxm_tclParkingApp();

    // Initialize the parking service
    virtual tVoid vInitialize(tVoid);

    // DeInitialize the Parking service
    virtual tVoid vDeInitialize(tVoid);

    // dispatch thread-messages specific for parking-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    //method to print Parking Report
    tVoid vPrintReportSpecific();

    virtual tVoid vPostInternalMsg(const fc_sxm_trMsgParkingSMSeRequestCallback & );
    virtual tVoid vPostInternalMsg(const fc_sxm_trMsgParkingSMSePOICallback & );

    virtual tBool bIsFavorite(tU32 u32ParkingID) const;
    virtual tF32 f32GetDistanceFromDestination(tF32 f32Lat,tF32 f32Lon);
    virtual tF32 f32GetCurrentDistance(tS32 s32Lat,tS32 s32Lon);
    virtual tF32 f32GetDistanceFromFrozenDevicePos(tF32 f32Lat,tF32 f32Lon);

    static tBool bCompareDistance(midw_ext_fi_tcl_ParkingInfo const& first,midw_ext_fi_tcl_ParkingInfo const& second);

    virtual tU32 u32GetCapacity(tU32) const;
    virtual tF32 f32GetRadius(tU32 u32ListID) const;
    virtual tU8 u8GetCurentWeekDay() const {return _oLocalTime.u8Weekday;}
    virtual tU8 u8GetCurentHour() const{return _oLocalTime.u8Hours;}
    virtual tU8 u8GetCurentMinutes() const{return _oLocalTime.u8Minutes;}

	//timer functions
	virtual tVoid vProcessTimer(fc_sxm_trMsgParkingListUpdateTimer const *prMsg);
	virtual tVoid vStartListTimer(tU32 u32ListID);
	virtual tVoid vStopListTimer(tVoid);
	tBool bIsListUpdateTimerRunning(tVoid) const;

	virtual tVoid vFreezeDevicePosition();
	virtual tVoid vReleaseDevicePosition();

    virtual tVoid vSendUpdate(tU32);

protected:

    SXM_SMSE_DATASRV_ACCESS(NULL, _hParking);

    // Start the service (Mandatory, dispatched by Base-Class)
    virtual tVoid vStartSmsService();

    //Stop Parking Service
    virtual tVoid vStopSmsService();



    //over ridden from data app to clear the old data during re-initialization of sms service.
    tVoid vClearServiceData(tVoid);

    //handle device position from Navi
    virtual tVoid vOnNewDevicePosition(fc_sxm_trSDKLocation&);
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);
    virtual tVoid vSetClockParams(fc_sxm_trMsgDataAppSetClockParams const *prMsg);

    //Other private Methods
private:

    //Creates Parking List
    tVoid vCreateParkingList();

    // fi-messages
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);
    tVoid vHandleTTFIsCmdParkingList(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdSetParkingFilter(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdSetParkingInfo(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdSaveParkingID(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdRemoveParkingID(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdRestoreFavorites(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    tVoid vHandleTTFIsCmdSetListMode(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg) const;
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartGetParkingList const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartGetParkingInfo const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingSMSeRequestCallback const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingSMSePOICallback const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartSetParkingFilterConfig const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartSetParkingFilterConfiguration const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartSaveParkingID const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartRemoveParkingID const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingMStartRestoreFavorites const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgParkingPSetListMode const *prMsg);
    virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataAppSetDestLocation const *prMsg);
    virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);

    tVoid vGetCombinedPPOIList(vector<PPOISpec>& vecPPOIs);
    tVoid vCreatePOIList();

    tVoid vSortListByDistance(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& oMRes) const;
    tVoid vSortListByUserOrder(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& oMRes) const;
    tVoid vUpdateDistance(midw_ext_sxm_parkingfi_tclMsgGetParkingInfoListMethodResult& oMRes);

    //member variables
private:

    /* Constructor */
    fc_sxm_tclParkingApp();

    //Parking Service Object
    DATASERVICE_MGR_OBJECT _hParking;

    //Factory class pointer
    fc_sxm_tclIParkingManager* _poParkingManager;

    //Proxy Pointer
    fc_sxm_tclIParkingSdkProxy* _poProxy;

    fc_sxm_trSDKLocation _rSDKDestLocation;

    fc_sxm_trSDKLocation _rFrozenDevicePos;

    midw_ext_fi_tcl_LocalTimeDate _oLocalTime;

    /* Timer to handle List updates */
    fc_sxm_tclTimer<fc_sxm_tclParkingApp,
    	fc_sxm_trMsgParkingListUpdateTimer> _mListUpdateTimer;

};

#endif //_FC_SXM_TCL_PARKING_APP_H_
