/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_movies_dsrl.h
* @brief       Declaration of Movies DSRL for a specified location.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_MOVIES_DSRL_H_
#define _FC_SXM_TCL_MOVIES_DSRL_H_

#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_movies_types.h"

/* Macro to enable for Debugging/Testing purpose */
#define DEBUG_MOVIES 1

/* movies-specific configuration of dsrl */
struct fc_sxm_trMoviesDSRLCfg:public fc_sxm_trDSRLBaseCfg
{
public:
   // constructor
   fc_sxm_trMoviesDSRLCfg() :
	   enSortMethod(fc_sxm_enMoviesSortMethod_NONE)
   {}
   // constructor uses fc_sxm_trDSRLGenericCfg class
   fc_sxm_trMoviesDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg) {

      u32Capacity=rGenericCfg.u32Capacity;
      rLocation=rGenericCfg.rLocation;
      u32Radius=rGenericCfg.u32Radius;
      enSortMethod=(fc_sxm_tenMoviesSortMethod)rGenericCfg.u8SortMethod;

   }

   virtual tVoid vPrintSpecific() const;
   fc_sxm_tenMoviesSortMethod enSortMethod;
   fc_sxm_trMoviesDSRLFilterCfg rFilterCfg;

};
/* 
	Movies DSRL Class 
*/
class fc_sxm_tclMoviesDSRL : 
   public fc_sxm_tclConfigDSRL<fc_sxm_trMoviesDSRLCfg> 
{

public:
   /* Constuctor */
   fc_sxm_tclMoviesDSRL(fc_sxm_tenDSRLType enDsrlType);

   /* Destructor */
   virtual ~fc_sxm_tclMoviesDSRL();

   /* Update notification when the DSRL is ready and iterated */
   virtual tVoid vOnDSRLUpdate(tVoid);

   /* 
		Method to Handle Filter Callbacks 
	*/
   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL, 
                                       DSRL_ENTRY_OBJECT hEntry);
   /* 
	   Method to Handle Sort Callbacks 
	*/
   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);
   
   virtual tVoid vHandleDsrlEntryInvalid(DSRL_ENTRY_ID tEntryID);
   /* 
		Method to Handle Iterate Callbacks 
	*/
   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL, 
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);

   static BOOLEAN bIterateMovieShowTimes(THEATER_OBJECT hTheater,
								  MOVIE_OBJECT hMovie,
								  UN32 un32StartTime,
								  void *pvEventCallbackArg);
   static BOOLEAN bIterateTheaterMovies( THEATER_OBJECT hTheater,
								  MOVIE_OBJECT hMovie,
								  void *pvEventCallbackArg );

private:
   tVoid vGetTheatreAmenities (THEATER_OBJECT hTheater,
		                          vector <midw_ext_fi_tcl_e8_TheatreAmenities>& hAmenityList) const;
};

#endif //_FC_SXM_TCL_MOVIES_DSRL_H_
