/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_movies_types.h
* @brief       Declaration of the Movies Types and includes the SMS library.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_MOVIES_TYPES_H
#define FC_SXM_MOVIES_TYPES_H

#include "fc_sxm_sms.h"

/*
	SMS-default sort-method must have number 0
*/
typedef enum
{
   fc_sxm_enMoviesSortMethod_NONE = 0,
   fc_sxm_enMoviesSortMethod_DISTANCE,
   fc_sxm_enMoviesSortMethod_NAME,
   fc_sxm_enMoviesSortMethod_FIRST_SAVED_FIRST   //LAST Saved At Bottom

} fc_sxm_tenMoviesSortMethod;

typedef enum
{
   fc_sxm_enMoviesFilterMethod_NONE = 0,
   fc_sxm_enMoviesFilterMethod_MOVIEID,
   fc_sxm_enMoviesFilterMethod_NAME
} fc_sxm_tenMoviesFilterMethod;

/*
	filter-configuration must provide operator!=
*/
struct fc_sxm_trMoviesDSRLFilterCfg {
    string  sMovieName;

    /* to check if filter has chanded, configuration has to provice operator!= */
    bool operator!=(fc_sxm_trMoviesDSRLFilterCfg const &b) const {
        SXM_RET_1_IF_NEQ(sMovieName);

        return false;
    }

};


#endif
