/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_fuel_dsrl.h
* @brief       Defines the fuel DSRL class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/
#ifndef _FC_SXM_TCL_FUEL_DSRL_H_
#define _FC_SXM_TCL_FUEL_DSRL_H_

#include "fc_sxm_tcl_base_dsrl.h"
#include "fc_sxm_fuel_types.h"

#define DEFAULT_FUELTYPE FUEL_TYPE_REGULAR




/* fuel-specific configuration of dsrl*/
struct fc_sxm_trFuelDSRLCfg:public fc_sxm_trDSRLBaseCfg
{
public:
    /* Default constructor*/
    fc_sxm_trFuelDSRLCfg():
    	enSortMethod(fc_sxm_enFuelDSRLSortMethod_NONE)
    {};
    /* Constructor uses fc_sxm_trDSRLGenericCfg*/
    fc_sxm_trFuelDSRLCfg(fc_sxm_trDSRLGenericCfg const &rGenericCfg) {
        u32Capacity=rGenericCfg.u32Capacity;
        rLocation=rGenericCfg.rLocation;
        u32Radius=rGenericCfg.u32Radius;
        enSortMethod=(fc_sxm_tenFuelDSRLSortMethod)rGenericCfg.u8SortMethod;
        rFilterCfg.enFuelType=(FUEL_TYPE_ENUM)rGenericCfg.u8FilterMethod;
        rFilterCfg.sBrand=rGenericCfg.oString;
    }

    fc_sxm_tenFuelDSRLSortMethod enSortMethod;
    fc_sxm_trFuelDSRLFilterCfg rFilterCfg;
    virtual tVoid vPrintSpecific() const;

};

/* Fuel DSRL handling class */
class fc_sxm_tclFuelDSRL :
   public fc_sxm_tclConfigDSRL<fc_sxm_trFuelDSRLCfg>
{

public:
   /* Constuctor*/
   fc_sxm_tclFuelDSRL(fc_sxm_tenDSRLType enDsrlType);

   /*Destructor*/
   virtual ~fc_sxm_tclFuelDSRL();

   /*Update notification when the DSRL is ready and iterated*/
   virtual tVoid vOnDSRLUpdate(tVoid);

   virtual tBool bHandleFilterCallback(DSRL_OBJECT hDSRL,
                                       DSRL_ENTRY_OBJECT hEntry);

   virtual tS16 s16HandleSortCallback(DSRL_OBJECT hDSRL,
                                      DSRL_ENTRY_OBJECT hEntry1,
                                      DSRL_ENTRY_OBJECT hEntry2);

   virtual tBool bHandleIterateCallback(DSRL_OBJECT hDSRL,
                                        DSRL_ENTRY_ID tEntryID,
                                        DSRL_ENTRY_STATUS_ENUM eStatus,
                                        DSRL_ENTRY_OBJECT hEntryObject);
   virtual tVoid vHandleDsrlEntryInvalid(DSRL_ENTRY_ID tEntryID);
   

private:

   /*Get Amenitys*/
   tVoid vGetAmenity(FUEL_STATION_OBJECT hStation, string &sAmenity) const;
  /*Get fuel Amenitys as enum type*/ 
   tVoid vGetAmenityEnum(FUEL_STATION_OBJECT hStation, vector<midw_ext_fi_tcl_e8_FuelStationAmenity> &hAmenity) const;

   /* patch a specific dsrl-entry according to rTestModification */
   tVoid vApplyTestModification(DSRL_ENTRY_ID tEntryID, fc_sxm_trFuelListEntry &rListEntry, DSRL_ENTRY_STATUS_ENUM &eStatus);

   /*Store All Brand Name*/
   static set<string> _poBrandNameList;
   /*Flag for New Brand Name found*/
   volatile tBool _u8BrandUpdateStatus; 

};

#endif //_FC_SXM_TCL_FUEL_DSRL_H_
