/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_fuel_app.h
* @brief       Defines the fuel Application handler class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_FUEL_APP_H_
#define _FC_SXM_TCL_FUEL_APP_H_

#include "fc_sxm_fuel_fi.h"
#include "fc_sxm_tcl_fuel_list.h"
#include "fc_sxm_tcl_fuel_properties.h"
#include "fc_sxm_tcl_data_app.h"

struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclFuelDSRL;
struct fc_sxm_trFuelDSRLCfg;
struct fc_sxm_trFuelListEntry;



/* messges representing callbacks from sms*/
struct fc_sxm_trMsgFuelSmsEvtFilter: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 101);
};

struct fc_sxm_trMsgFuelSmsEvtSort: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 102);

};


/* method-start from cca-service*/
struct fc_sxm_trMsgFuelMStartGetList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_fuelfi_tclMsgGetFuelInfoListMethodStart oFiMsg;

};

struct fc_sxm_trMsgFuelMStartGetStationInfo: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 201);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_fuelfi_tclMsgGetFuelStationInfoMethodStart oFiMsg;
};

struct fc_sxm_trMsgFuelMStartSetListsConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 202);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_fuelfi_tclMsgSetListsConfigMethodStart oFiMsg;

};
struct fc_sxm_trMsgFuelMStartAddFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 203);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_fuelfi_tclMsgAddFavoriteMethodStart oFiMsg;

};
struct fc_sxm_trMsgFuelMStartRemoveFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 204);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_fuelfi_tclMsgRemoveFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trPropertyFuelPSetListMode: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 205);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_fuelfi_tclMsgSxmListModeSet oFiMsg;

};
#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
/* messages send for timer concept */
struct fc_sxm_trMsgListUpdateFuelTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Fuel, 206);
};
#endif


/* container for fuel type information */
struct fc_sxm_trFuelType
{
  string sFuelYpe;
  FUEL_TYPE_ENUM eFuelType;
  
  fc_sxm_trFuelType() :
     sFuelYpe(""),
	 eFuelType(FUEL_TYPE_UNKNOWN)
  {}
};

/*
  the fuel-app class
*/
class fc_sxm_tclFuelApp :
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclFuelApp>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclFuelApp>;

 public:
    
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Fuel;
    /*Destructor*/
    virtual ~fc_sxm_tclFuelApp();


    /*Initialize the fuel service*/
    virtual tVoid vInitialize(tVoid);

    /*DeInitialize the fuel service*/
    virtual tVoid vDeInitialize(tVoid);
#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING

    virtual tVoid vProcessTimer(fc_sxm_trMsgListUpdateFuelTimer const *prMsg);

   /*
      start the timer for 10 seconds
   */
    tVoid vStartListTimer(tVoid);
    tVoid vStopListTimer(tVoid);
    tBool bIsListUpdateTimerRunning(tVoid) const;

#endif
    /*Get all available fuel types */
    tVoid vSendFuelTypes(tVoid);

    /* dispatch thread-messages specific for fuel-app*/
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    tVoid vPrintReportSpecific();

	
    /* 
	   Method to Extract SMS Location Object to FI Location type
   */
    midw_ext_fi_tcl_SxmLocation rGetFuelLocation(LOCATION_OBJECT hLocObj) const;
 protected:
    virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);

    SXM_SMS_DATASRV_ACCESS(FUEL, _hFuel);

    virtual tBool bResetProductState(){return FALSE;};
    /* commands From CCA-Thread:
    Start the service (Mandatory, dispatched by Base-Class)*/
    virtual tVoid vStartSmsService();

    //Favorite methods to be implemented
    virtual tVoid vRestoreFavorites();
    virtual tVoid vPersistFavorites();
 private:
    /* ttfis-cmds*/
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

    /* messages specific for fuel-app go from here
    // fi-messages*/

    tVoid vProcess(fc_sxm_trMsgFuelMStartGetList const *prMsg);
    tVoid vProcess(fc_sxm_trMsgFuelMStartGetStationInfo const *prMsg);
    tVoid vProcess(fc_sxm_trMsgFuelMStartSetListsConfig  const *prMsg);
	tVoid vProcess(fc_sxm_trMsgFuelMStartAddFavorite const *prMsg);
    tVoid vProcess(fc_sxm_trMsgFuelMStartRemoveFavorite const *prMsg);
    tVoid vProcess(fc_sxm_trPropertyFuelPSetListMode  const *prMsg);
	tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);
    /* called to clear user-data, default implementation:
      vSetUsrDataClearResult(fc_sxm_enDiagResult_NoAction)
      if app has to to something, vSetUsrDataClearResult has to be called
      with appropriate code (fc_sxm_enDiagResult_Ok or fc_sxm_enDiagResult_Failed)
      after action is done, e.g. 
      audio: set default channel, delete presets,
      data: clear favorites
   */
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);

    /*Constructor*/
    fc_sxm_tclFuelApp();
    /*To Create DSRL object and List Object*/
    tVoid vCreateDsrlAndList(fc_sxm_tenDSRLType enDsrlType, fc_sxm_tenListType enListType, fc_sxm_tclFuelDSRL **ppoDsrl, fc_sxm_trFuelDSRLCfg rDsrlCfg,
                             fc_sxm_trFuelList **ppoList);
    /*Fill All station info from fuel entry list*/
    tVoid vFillStationInfo(midw_ext_fi_tcl_FuelStationInfo &rStationInfo, fc_sxm_trFuelListEntry const &rEntry) const;
    /*Check the SmxID is present in the list entry : TRUE for sucess*/
    tBool bIsUpdateEntry(tU32 u32SxmID);

	
	/*Sms Call back to get fuel type*/
	
	static tBool bHandleFuelTypeCallback(STRING_OBJECT hFuelType,
                              FUEL_TYPE_ENUM eFuelType,
                              void *pvIteratorArg); 

   virtual tBool bEnableDataProducts() const;
   virtual tVoid vDisableDataProducts();
   virtual DATA_PRODUCT_STATE_ENUM enGetDataProductState(DATASERVICE_MGR_OBJECT hDataService) const;
   DATA_PRODUCT_STATE_ENUM enGetDBProductState(DATASERVICE_MGR_OBJECT hDataService) const;
   DATA_PRODUCT_STATE_ENUM enGetFuelPriceProductState(DATASERVICE_MGR_OBJECT hDataService) const;
	
    /*Get The Fuel Service object*/
    FUEL_SERVICE_OBJECT _hFuel;
    /*Sort Method*/
    FUEL_PRICE_SORT_METHOD_ENUM _enSortMethod;
	/*Location Object*/
    LOCATION_OBJECT _hLocation;
    /*DSRL Object*/
    DSRL_OBJECT _hDSRL;
    /*Create Fuel Dsrl for each list ID*/
    fc_sxm_tclFuelDSRL *_poNearByDsrl;
    fc_sxm_tclFuelDSRL *_poNearDestDsrl;
    fc_sxm_tclFuelDSRL *_poFavDsrl;
    /*Create Fuel List for each list ID*/
    fc_sxm_trFuelList *_poNearByList;
    fc_sxm_trFuelList *_poDestList;
    fc_sxm_trFuelList *_poFavList;

    /* Get Capacity and Radius*/
    tU32 _u32Capacity;
    tU32 _u32Radius;
    fc_sxm_tenListMode _enTestListMode;
   /*Store All Unknown Fuel Name*/
    static vector<string> _vUnknownFuelName;
   /*Store New Fuel type Name*/
    static vector<fc_sxm_trFuelType> _vFuelTypeList;

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
	/* Timer to handle List updates */
    fc_sxm_tclTimer<fc_sxm_tclFuelApp, 
        fc_sxm_trMsgListUpdateFuelTimer> _mListUpdateTimer;

#endif
};

#endif //_FC_SXM_TCL_FUEL_APP_H_
