/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channelart_properties.h
* @brief       Defines properties for channel art service
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#ifndef FC_SXM_TCL_CHANNELART_PROPERTIES_H
#define FC_SXM_TCL_CHANNELART_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_channelart_fi.h"

/*
  Semaphore-protected data of channelart-app
*/



struct fc_sxm_tcl_trChannelartPropertySxmServiceStatus {
    fc_sxm_tcl_trChannelartPropertySxmServiceStatus()
    {}
    bool operator!=(fc_sxm_tcl_trChannelartPropertySxmServiceStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_channelartfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
 
};

    class fc_sxm_tclChannelartProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclChannelartProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclChannelartProperties>;
 public:


    fc_sxm_tclAutoProperty<fc_sxm_tcl_trChannelartPropertySxmServiceStatus, 
        CCA_C_U16_SRV_SXM_CHANNEL_ART, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_CHANNELARTFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
        > oSxmServiceStatus;

};

#endif
