/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_channelart_app.cpp
* @brief       Application handler implementation for Channel Art services.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_common.h"
#include "fc_sxm_main.h"
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_sms_init.h"
#include "fc_sxm_service_sxm_channelart.h"
#include "fc_sxm_tcl_channelart_app.h"
#include "fc_sxm_channelart_fi.h"
#include "fc_sxm_tcl_channelart_data.h"
#include "fc_sxm_tcl_channelart_properties.h"

typedef enum 
{
    fc_sxm_enTtfisCmdsChannelart_GET_CHANNELART       = 01,

    fc_sxm_enTtfisCmdsChannelart_GET_ALBUMART	      = 02,

    fc_sxm_enTtfisCmdsChannelart_GET_CHANNELARTLIST	  = 03

} fc_sxm_enTtfisCmdsChannelart;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_CHANNELART_APP
#include "trcGenProj/Header/fc_sxm_tcl_channelart_app.cpp.trc.h"
#endif

/*
  Implementation of all callback-functions for the sms needed by Channelart.
  Only communication to audio-app:
  1.) Posting messages using fc_sxm_tclChannelartApp::instance()->vPostMsgNew(rMsg);
  
*/



/*******************************************************************************
*
*FUNCTION:          fc_sxm_tclChannelartApp
*
*DESCRIPTION:       Constructor
*
*PARAMETERS:        None 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
/* 
   peha: constructor: give it a name and provice the used sxmServiceId (not the ccaServiceId!!)
 */
fc_sxm_tclChannelartApp::fc_sxm_tclChannelartApp():
    fc_sxm_tclDataApp("sxmChannelartApp", _enStaticServiceId, CCA_C_U16_SRV_SXM_CHANNEL_ART, "channelart", TR_CLASS_FC_SXM_CHANNELART_APP)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp constructor"));
    _hChannelart = CHANNEL_ART_SERVICE_INVALID_OBJECT;
    _bDataProductsEnabled = FALSE;
}

/*******************************************************************************
*
*FUNCTION:          ~fc_sxm_tclChannelartApp
*
*DESCRIPTION:       Destructor
*
*PARAMETERS:        None 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
fc_sxm_tclChannelartApp::~fc_sxm_tclChannelartApp()
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp destructor"));
    _hChannelart = CHANNEL_ART_SERVICE_INVALID_OBJECT;

    OSAL_DELETE fc_sxm_tclChannelArtData::instance();
}

/*******************************************************************************
*
*FUNCTION:          vInitialize
*
*DESCRIPTION:       Called in cca context by sxmapp-manager
                    Initializes the helper class also
*
*PARAMETERS:        None 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
tVoid fc_sxm_tclChannelartApp::vInitialize(tVoid)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vInitialize"));

    //Initialize the class members
    _hChannelart = CHANNEL_ART_SERVICE_INVALID_OBJECT;
    
	/* call vInitialize() of base-class to stop the worker thread */
    fc_sxm_tclBaseApp::vInitialize();


}

/*******************************************************************************
*
*FUNCTION:          vDeInitialize
*
*DESCRIPTION:       Called in cca context by sxmapp-manager
                    DeInitializes the helper class also.
*
*PARAMETERS:        None 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/

tVoid fc_sxm_tclChannelartApp::vDeInitialize(tVoid)
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vDeInitialize"));
    /* call vDeInitialize() of base-class to stop the worker thread */
    fc_sxm_tclBaseApp::vDeInitialize();

    /* Deinit of all other stuff starts from here */
}

/*******************************************************************************
*
*FUNCTION:          vProcess
*
*DESCRIPTION:       Called in cca context by sxmapp-manager
                    DeInitializes the helper class also.
*
*PARAMETERS:        None 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
tVoid fc_sxm_tclChannelartApp::vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg)
{
    fc_sxm_enTtfisCmdsChannelart enMsgCode=(fc_sxm_enTtfisCmdsChannelart)prMsg->u8MsgCode;
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vProcess(fc_sxm_enTtfisCmdsChannelart) code=%d",
                    ETG_CENUM(fc_sxm_enTtfisCmdsChannelart, enMsgCode)));

    tU8 u8Param1 = prMsg->au8Data[0];
	tU8 u8Param2 = prMsg->au8Data[1];
	tU8 u8Param3 = prMsg->au8Data[2];
	tU8 u8Param4 = prMsg->au8Data[3];
	tU8 u8Param5 = prMsg->au8Data[4];
	tU8 u8Param6 = prMsg->au8Data[5];
	tU8 u8Param7 = prMsg->au8Data[6];
	tU8 u8Param8 = prMsg->au8Data[7];
    
	switch (enMsgCode) 
	{
	case fc_sxm_enTtfisCmdsChannelart_GET_CHANNELART:
		{
			midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart oMStart;
			oMStart.SID=u8Param1;
            ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vProcess() ==== oMStart.SID - %d", oMStart.SID));
            ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vProcess() ==== u8Param1 - %d", u8Param1));
			fc_sxm_vSendSelfMessage(oMStart);
		}
		break;

	case fc_sxm_enTtfisCmdsChannelart_GET_ALBUMART:
		{
			midw_ext_sxm_channelartfi_tclMsgGetChannelArtMethodStart oMStart;
			oMStart.ChannelGraphicsType = u8Param1;
			fc_sxm_vSendSelfMessage(oMStart);
		}
		break;

		default:
		{
            ETG_TRACE_ERR(("fc_sxm_tclChannelartApp::vProcess(fc_sxm_enTtfisCmdsChannelart) unknown code=%d",
                           ETG_CENUM(fc_sxm_enTtfisCmdsChannelart, enMsgCode)));
		}
        break;

	case fc_sxm_enTtfisCmdsChannelart_GET_CHANNELARTLIST:
		{
			midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart oMStart;
			oMStart.ListOfSID.push_back(u8Param1);
			oMStart.ListOfSID.push_back(u8Param2);
			oMStart.ListOfSID.push_back(u8Param3);
			oMStart.ListOfSID.push_back(u8Param4);
			oMStart.ListOfSID.push_back(u8Param5);
			oMStart.ListOfSID.push_back(u8Param6);
			oMStart.ListOfSID.push_back(u8Param7);
			(oMStart.ChannelGraphicsType) = u8Param8;
			fc_sxm_vSendSelfMessage(oMStart);
		}
        break;
	}
}
/*******************************************************************************
*
*FUNCTION:          vDispatchMsgFromQ
*
*DESCRIPTION:       Called by the thread-function.
                    For each message that shall be handled put and entry here.

*PARAMETERS:        *poThreadMsg 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
tVoid fc_sxm_tclChannelartApp::vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg) {
ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vDispatchMsgFromQ: SID=%x action=%d",
                    ETG_CENUM(fc_sxm_tenServiceID, poThreadMsg->enGetServiceId()), 
                    poThreadMsg->u16GetActionOnly()));
    tU32 u32Action=poThreadMsg->u32GetAction();
    switch (u32Action) {
        // use macro SXM_MSGQ_DISPATCH  for each message specific for channelart

        /* method-start messages from cca-service */
        SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgChannelartMStartGetChannelArt, fc_sxm_tclChannelArtData::instance());
        
        /* method-start messages from cca-service */
        SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgChannelartMStartGetChannelArtList, fc_sxm_tclChannelArtData::instance());

        default:
            ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vDispatchMsgFromQ(): unknown u32Action=0x%x",
                            u32Action));
            break;         
    }
}



/*******************************************************************************
*
*FUNCTION:          vProcess
*
*DESCRIPTION:       handle command from sxmAppManager to start the service

*PARAMETERS:        fc_sxm_trMsgCmdDataAppStartService *prMsg 
*
*RETURNVALUES:      None
*                    
*********************************************************************************/
tVoid fc_sxm_tclChannelartApp::vStartSmsService()
{
    ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::bStartService"));

    //Check if the channelart service is already started
    if (_hChannelart != CHANNEL_ART_SERVICE_INVALID_OBJECT)
    {
        ETG_TRACE_USR4(("Channelart service already started!"));
        return;
    }

    _hChannelart = CHANNEL_ART.hStart(FC_SXM_SRH_DRIVER_NAME,            /* SRH driver name */
                                      CHANNEL_ART_SERVICE_EVENT_ALL,
                                      cb_vDataServiceEventCallback,    /* Generic service callback */
                                      (tVoid*)this,
                                      (CHANNEL_ART_AVAILABLE_IMAGE_LOGO) | (CHANNEL_ART_AVAILABLE_IMAGE_ALBUM),
                                      DATASERVICE_OPTION_NONE);  
    if (_hChannelart == CHANNEL_ART_SERVICE_INVALID_OBJECT)
    {
        ETG_TRACE_ERR(("Could not start Channelart service"));
    }
    else
    {
        ETG_TRACE_USR4(("Channelart service started successfully"));
    }
}

// Application get notified about the new fi-service-state that shall be sent to clients
tVoid fc_sxm_tclChannelartApp::vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState) 
{
    ETG_TRACE_USR4(("--->fc_sxm_tclChannelartApp::vOnFiServiceStateChanged,"
                                              "State = %d",oFiState.Status.enType));
    fc_sxm_tcl_trChannelartPropertySxmServiceStatus oProperty;
    oProperty.oFiMsg.DataServiceState=oFiState;
    if(midw_ext_fi_tcl_e8_SxmDataServiceStatus::FI_EN_SUBSCRIBED == oFiState.Status.enType)
    {
    	ETG_TRACE_USR4(("FI_EN_SUBSCRIBED Successfully"));
        fc_sxm_tclChannelArtData::instance()->vSetChannelArtServiceState(TRUE);
    }
    else
    {
    	ETG_TRACE_USR4(("FI_EN_SUBSCRIBED NotSuccessfully"));
        fc_sxm_tclChannelArtData::instance()->vSetChannelArtServiceState(FALSE);
    }
    fc_sxm_tclChannelartProperties::instance()->oSxmServiceStatus.vSetAndNotify(oProperty);
}
tVoid fc_sxm_tclChannelartApp::vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg) {
 	
	(tVoid) prMsg ;
}

tBool fc_sxm_tclChannelartApp::bEnableDataProducts() const{

	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vEnableDataProducts()"));

    SMSAPI_RETURN_CODE_ENUM eReturnCode; 

    // Enable the Channel Art product
    eReturnCode = DATA.eEnableProduct( _hChannelart, DATA_PRODUCT_TYPE_CHANNEL_ART,DATA_PRODUCT_MASK_NONE);
    if (eReturnCode != SMSAPI_RETURN_CODE_SUCCESS) {
       ETG_TRACE_USR4(("failed to enable DATA_PRODUCT_TYPE_CHANNEL_ART "));
       return FALSE;
    }

    // Enable the Album Art product
	eReturnCode = DATA.eEnableProduct( _hChannelart, DATA_PRODUCT_TYPE_ALBUM_ART,DATA_PRODUCT_MASK_NONE);
	if (eReturnCode != SMSAPI_RETURN_CODE_SUCCESS) {
	   ETG_TRACE_USR4(("failed to enable DATA_PRODUCT_TYPE_ALBUM_ART "));
	   return FALSE;
	}

    return TRUE;
}

DATA_PRODUCT_STATE_ENUM fc_sxm_tclChannelartApp::enGetDataProductState(DATASERVICE_MGR_OBJECT hDataService) const {

	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::enGetDataProductState" ));

	/*Check if Channel art and Album art products are enabled*/
	DATA_PRODUCT_STATE_ENUM enChnArtSt = enGetChannelArtProductState(hDataService);
	DATA_PRODUCT_STATE_ENUM enAlbArtSt = enGetAlbumArtProductState(hDataService);
	DATA_PRODUCT_STATE_ENUM enRetSt = DATA_PRODUCT_STATE_ERROR;

	if ((enChnArtSt == DATA_PRODUCT_STATE_DISABLED) &&
			(enAlbArtSt == DATA_PRODUCT_STATE_DISABLED))
	{
		enRetSt = DATA_PRODUCT_STATE_DISABLED;
	}

	else if ((enChnArtSt == DATA_PRODUCT_STATE_INITIAL) &&
				(enAlbArtSt == DATA_PRODUCT_STATE_INITIAL))
	{
		enRetSt = DATA_PRODUCT_STATE_INITIAL;
	}

	else if ((enChnArtSt == DATA_PRODUCT_STATE_READY) &&
					(enAlbArtSt == DATA_PRODUCT_STATE_READY))
	{
		enRetSt = DATA_PRODUCT_STATE_READY;
	}
	else if ((enChnArtSt == DATA_PRODUCT_STATE_UNSUBSCRIBED) &&
                    (enAlbArtSt == DATA_PRODUCT_STATE_UNSUBSCRIBED))
    {
        enRetSt = DATA_PRODUCT_STATE_UNSUBSCRIBED;
    }
	return enRetSt;
}

DATA_PRODUCT_STATE_ENUM fc_sxm_tclChannelartApp::enGetChannelArtProductState(DATASERVICE_MGR_OBJECT hDataService) const{
	DATA_PRODUCT_STATE_ENUM eState = DATA_PRODUCT_STATE_DISABLED;
	DATA_PRODUCT_MASK eMask;
	SMSAPI_RETURN_CODE_ENUM eReturn;

	// Get the state of the Channel Art
	eReturn = DATA.eProductState(
		   hDataService,
		   DATA_PRODUCT_TYPE_CHANNEL_ART, &eMask,
		   &eState );
	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::enGetChannelArtProductState() State=%d",ETG_CENUM(DATA_PRODUCT_STATE_ENUM, eState) ));

	if ( SMSAPI_RETURN_CODE_SUCCESS != eReturn )
	{
	   ETG_TRACE_USR4(("failed to get state of DATA_PRODUCT_TYPE_CHANNEL_ART ReturnCode=%d,State=%d",
						ETG_CENUM(SMSAPI_RETURN_CODE_ENUM, eReturn),
						ETG_CENUM(DATA_PRODUCT_STATE_ENUM, eState)
					 ));
	}
	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::enGetChannelArtProductState return eState" ));

	return eState;
}

DATA_PRODUCT_STATE_ENUM fc_sxm_tclChannelartApp::enGetAlbumArtProductState(DATASERVICE_MGR_OBJECT hDataService) const{
	DATA_PRODUCT_STATE_ENUM eState = DATA_PRODUCT_STATE_DISABLED;
	DATA_PRODUCT_MASK eMask;
	SMSAPI_RETURN_CODE_ENUM eReturn;

	// Get the state of the Album Art
	eReturn = DATA.eProductState(
		   hDataService,
		   DATA_PRODUCT_TYPE_ALBUM_ART, &eMask,
		   &eState );
	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::enGetAlbumArtProductState() State=%d",ETG_CENUM(DATA_PRODUCT_STATE_ENUM, eState) ));

	if ( SMSAPI_RETURN_CODE_SUCCESS != eReturn )
	{
	   ETG_TRACE_USR4(("failed to get state of DATA_PRODUCT_TYPE_ALBUM_ART ReturnCode=%d,State=%d",
						ETG_CENUM(SMSAPI_RETURN_CODE_ENUM, eReturn),
						ETG_CENUM(DATA_PRODUCT_STATE_ENUM, eState)
					 ));
	}
	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::enGetAlbumArtProductState return eState = %d", ETG_CENUM(DATA_PRODUCT_STATE_ENUM, eState) ));

	return eState;
}

tVoid fc_sxm_tclChannelartApp::vDisableDataProducts() {

	ETG_TRACE_USR4(("fc_sxm_tclChannelartApp::vDisableDataProducts" ));

     SMSAPI_RETURN_CODE_ENUM eReturn;

    // Disable Channel Art products
    eReturn = DATA.eDisableProduct(
          _hChannelart,
           DATA_PRODUCT_TYPE_CHANNEL_ART );

    if ( SMSAPI_RETURN_CODE_SUCCESS != eReturn )
    {
       ETG_TRACE_USR4(("failed to disable DATA_PRODUCT_TYPE_CHANNEL_ART ReturnCode=%d",
                        ETG_CENUM(SMSAPI_RETURN_CODE_ENUM, eReturn)
                     ));    
    }

    // Disable Channel Art products
	eReturn = DATA.eDisableProduct(
		  _hChannelart,
		  DATA_PRODUCT_TYPE_ALBUM_ART );

	if ( SMSAPI_RETURN_CODE_SUCCESS != eReturn )
	{
	   ETG_TRACE_USR4(("failed to disable DATA_PRODUCT_TYPE_ALBUM_ART ReturnCode=%d",
						ETG_CENUM(SMSAPI_RETURN_CODE_ENUM, eReturn)
					 ));
	}

}

