/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_canadian_fuel_properties.h
* @brief       Declaration for canadian fuel service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_CANADIAN_FUEL_PROPERTIES_H
#define FC_SXM_TCL_CANADIAN_FUEL_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_canadian_fuel_fi.h"

/*
  Semaphore-protected data of canadian fuel-app
*/


/* example for property, where fi-type is stored directly in member "oFiMsg"*/
/* Property To Send Status*/
struct fc_sxm_tcl_trCanadianFuelPropertyListsStatus {
    /* constructor */
    fc_sxm_tcl_trCanadianFuelPropertyListsStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trCanadianFuelPropertyListsStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Info List status */
    midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelInfoListsStatusStatus oFiMsg;
 
};

/* Property To Send Available Brand Name*/

struct fc_sxm_tcl_trCanadianFuelPropertyBrandNameListStatus {
    /* constructor */
    fc_sxm_tcl_trCanadianFuelPropertyBrandNameListStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trCanadianFuelPropertyBrandNameListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Brand Name List status */
    midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelBrandNameListStatus oFiMsg;
 
};

/* Property To Send Fuel Type Name List*/

struct fc_sxm_tcl_trCanadianFuelPropertyTypeListStatus {
    /* constructor */
    fc_sxm_tcl_trCanadianFuelPropertyTypeListStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trCanadianFuelPropertyTypeListStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Fuel Type List status */
    midw_ext_sxm_canadian_fuelfi_tclMsgCanadianFuelTypeListStatus oFiMsg;
 
};

/* Property To Send Service status*/

struct fc_sxm_tcl_trCanadianFuelPropertySxmServiceStatus {
    /* constructor */
    fc_sxm_tcl_trCanadianFuelPropertySxmServiceStatus()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trCanadianFuelPropertySxmServiceStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Sxm data service status */
    midw_ext_sxm_canadian_fuelfi_tclMsgSxmDataServiceStatusStatus oFiMsg;
 
};

/* Property To Send SxmListMode status*/

struct fc_sxm_tcl_trCanadianFuelPropertySxmListMode {
    /* constructor */
	fc_sxm_tcl_trCanadianFuelPropertySxmListMode()
    {}
    /* Comparision operator */
    bool operator!=(fc_sxm_tcl_trCanadianFuelPropertySxmListMode const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }
    /* variable to store Sxm data service status */
    midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeStatus oFiMsg;

};

    class fc_sxm_tclCanadianFuelProperties:
    public fc_sxm_tclSingleton<fc_sxm_tclCanadianFuelProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclCanadianFuelProperties>;
 public:

    fc_sxm_tclProperty<fc_sxm_tcl_trCanadianFuelPropertyListsStatus, 
        CCA_C_U16_SRV_SXM_CANADIAN_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_CANADIANFUELINFOLISTSSTATUS /* give FID if notification to service is needed  */
        > oListsStatus;
    
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trCanadianFuelPropertyBrandNameListStatus, 
        CCA_C_U16_SRV_SXM_CANADIAN_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_CANADIANFUELBRANDNAMELIST /* give FID if notification to service is needed  */
        > oBrandNameStatus;
      
    fc_sxm_tclAutoProperty<fc_sxm_tcl_trCanadianFuelPropertyTypeListStatus, 
        CCA_C_U16_SRV_SXM_CANADIAN_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_CANADIANFUELTYPELIST /* give FID if notification to service is needed  */
        > oTypeNameStatus;        

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trCanadianFuelPropertySxmServiceStatus, 
        CCA_C_U16_SRV_SXM_CANADIAN_FUEL, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_SXMDATASERVICESTATUS /* give FID if notification to service is needed  */
        > oSxmServiceStatus;


    fc_sxm_tclAutoProperty<fc_sxm_tcl_trCanadianFuelPropertySxmListMode,
        CCA_C_U16_SRV_SXM_CANADIAN_FUEL, /*the service-id of the CCA-Service */
		MIDW_EXT_SXM_CANADIAN_FUELFI_C_U16_SXMLISTMODE /* give FID if notification to service is needed  */
        > oSxmListMode;
};

#endif //FC_SXM_TCL_CANADIAN_FUEL_PROPERTIES_H
