/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_canadian_fuel_app.h
* @brief       Defines the canadian fuel Application handler class.
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_CANADIAN_FUEL_APP_H_
#define _FC_SXM_TCL_CANADIAN_FUEL_APP_H_

#include "fc_sxm_canadian_fuel_fi.h"
#include "fc_sxm_tcl_canadian_fuel_list.h"
#include "fc_sxm_tcl_canadian_fuel_properties.h"
#include "fc_sxm_tcl_data_app.h"

struct fc_sxm_trMsgCmdAppTtfisCmd;
class fc_sxm_tclCanadianFuelDSRL;
struct fc_sxm_trCanadianFuelDSRLCfg;
struct fc_sxm_trCanadianFuelListEntry;



/* messges representing callbacks from sms*/
struct fc_sxm_trMsgCanadianFuelSmsEvtFilter: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 101);
};

struct fc_sxm_trMsgCanadianFuelSmsEvtSort: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 102);

};


/* method-start from cca-service*/
struct fc_sxm_trMsgCanadianFuelMStartGetList: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelInfoListMethodStart oFiMsg;

};

struct fc_sxm_trMsgCanadianFuelMStartGetStationInfo: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 201);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_canadian_fuelfi_tclMsgGetCanadianFuelStationInfoMethodStart oFiMsg;
};

struct fc_sxm_trMsgCanadianFuelMStartSetListsConfig: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 202);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_canadian_fuelfi_tclMsgSetListsConfigMethodStart oFiMsg;

};
struct fc_sxm_trMsgCanadianFuelMStartAddFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 203);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_canadian_fuelfi_tclMsgAddFavoriteMethodStart oFiMsg;

};
struct fc_sxm_trMsgCanadianFuelMStartRemoveFavorite: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 204);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_canadian_fuelfi_tclMsgRemoveFavoriteMethodStart oFiMsg;
};

struct fc_sxm_trPropertyCanadianFuelPSetListMode: public fc_sxm_tclMessage {
   SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 205);
   fc_sxm_trAdressing rAdressing;
   midw_ext_sxm_canadian_fuelfi_tclMsgSxmListModeSet oFiMsg;

};
#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
/* messages send for timer concept */
struct fc_sxm_trMsgListUpdateCanadianFuelTimer: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_Canadian_Fuel, 206);
};
#endif


/* container for fuel type information */
struct fc_sxm_trCanadianFuelType
{
  string sCanadianFuelYpe;
  FUEL_TYPE_ENUM eCanadianFuelType;

  fc_sxm_trCanadianFuelType() :
     sCanadianFuelYpe(""),
     eCanadianFuelType(FUEL_TYPE_UNKNOWN)
  {}
};

/*
  the canadian fuel-app class
*/
class fc_sxm_tclCanadianFuelApp :
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclCanadianFuelApp>

{
    friend class fc_sxm_tclSingleton<fc_sxm_tclCanadianFuelApp>;

 public:
    
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_Canadian_Fuel;
    /*Destructor*/
    virtual ~fc_sxm_tclCanadianFuelApp();


    /*Initialize the fuel service*/
    virtual tVoid vInitialize(tVoid);

    /*DeInitialize the fuel service*/
    virtual tVoid vDeInitialize(tVoid);
#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING

    virtual tVoid vProcessTimer(fc_sxm_trMsgListUpdateCanadianFuelTimer const *prMsg);

   /*
      start the timer for 10 seconds
   */
    tVoid vStartListTimer(tVoid);
    tVoid vStopListTimer(tVoid);
    tBool bIsListUpdateTimerRunning(tVoid) const;

#endif
    /*Get all available fuel types */
    tVoid vSendCanadianFuelTypes(tVoid);

    /* dispatch thread-messages specific for fuel-app*/
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    tVoid vPrintReportSpecific();

	
    /* 
	   Method to Extract SMS Location Object to FI Location type
   */
    midw_ext_fi_tcl_SxmLocation rGetCanadianFuelLocation(LOCATION_OBJECT hLocObj) const;
 protected:
    virtual tVoid vOnListStateChanged(fc_sxm_tclDataListBase *poDataList);
    virtual tVoid vOnFiServiceStateChanged(midw_ext_fi_tcl_SxmDataSrvState const &oFiState);

    SXM_SMS_DATASRV_ACCESS(FUEL, _hCanadianFuel);

    virtual tBool bResetProductState(){return FALSE;};
    /* commands From CCA-Thread:
    Start the service (Mandatory, dispatched by Base-Class)*/
    virtual tVoid vStartSmsService();

    //Favorite methods to be implemented
    virtual tVoid vRestoreFavorites();
    virtual tVoid vPersistFavorites();
    /* ttfis-cmds*/
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);

    /* messages specific for fuel-app go from here
    // fi-messages*/

    tVoid vProcess(fc_sxm_trMsgCanadianFuelMStartGetList const *prMsg);
    tVoid vProcess(fc_sxm_trMsgCanadianFuelMStartGetStationInfo const *prMsg) const;
    tVoid vProcess(fc_sxm_trMsgCanadianFuelMStartSetListsConfig  const *prMsg);
	tVoid vProcess(fc_sxm_trMsgCanadianFuelMStartAddFavorite const *prMsg);
    tVoid vProcess(fc_sxm_trMsgCanadianFuelMStartRemoveFavorite const *prMsg);
    tVoid vProcess(fc_sxm_trPropertyCanadianFuelPSetListMode  const *prMsg);
	tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);
    /* called to clear user-data, default implementation:
      vSetUsrDataClearResult(fc_sxm_enDiagResult_NoAction)
      if app has to to something, vSetUsrDataClearResult has to be called
      with appropriate code (fc_sxm_enDiagResult_Ok or fc_sxm_enDiagResult_Failed)
      after action is done, e.g. 
      audio: set default channel, delete presets,
      data: clear favorites
   */
   virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppClearUserData const *prMsg);

    /*Constructor*/
    fc_sxm_tclCanadianFuelApp();
    /*To Create DSRL object and List Object*/
    tVoid vCreateDsrlAndList(fc_sxm_tenDSRLType enDsrlType, fc_sxm_tenListType enListType, fc_sxm_tclCanadianFuelDSRL **ppoDsrl, fc_sxm_trCanadianFuelDSRLCfg rDsrlCfg,
                             fc_sxm_trCanadianFuelList **ppoList);
    /*Fill All station info from fuel entry list*/
    tVoid vFillStationInfo(midw_ext_fi_tcl_CanFuelStationInfo &rStationInfo, fc_sxm_trCanadianFuelListEntry const &rEntry) const;
    /*Check the SmxID is present in the list entry : TRUE for sucess*/
    tBool bIsUpdateEntry(tU32 u32SxmID);

	
	/*Sms Call back to get fuel type*/
	
	static tBool bHandleFuelTypeCallback(STRING_OBJECT hFuelType,
                              FUEL_TYPE_ENUM eCanadianFuelType,
                              void *pvIteratorArg); 

   virtual tBool bEnableDataProducts() const;
   virtual tVoid vDisableDataProducts();
   virtual DATA_PRODUCT_STATE_ENUM enGetDataProductState(DATASERVICE_MGR_OBJECT hDataService) const;
   DATA_PRODUCT_STATE_ENUM enGetDBProductState(DATASERVICE_MGR_OBJECT hDataService) const;
   DATA_PRODUCT_STATE_ENUM enGetFuelPriceProductState(DATASERVICE_MGR_OBJECT hDataService) const;
	
    /*Get The Fuel Service object*/
    FUEL_SERVICE_OBJECT _hCanadianFuel;
    /*Sort Method*/
    FUEL_PRICE_SORT_METHOD_ENUM _enSortMethod;
	/*Location Object*/
    LOCATION_OBJECT _hLocation;
    /*DSRL Object*/
    DSRL_OBJECT _hDSRL;
    /*Create Fuel Dsrl for each list ID*/
    fc_sxm_tclCanadianFuelDSRL *_poNearByDsrl;
    fc_sxm_tclCanadianFuelDSRL *_poNearDestDsrl;
    fc_sxm_tclCanadianFuelDSRL *_poFavDsrl;
    /*Create Fuel List for each list ID*/
    fc_sxm_trCanadianFuelList *_poNearByList;
    fc_sxm_trCanadianFuelList *_poDestList;
    fc_sxm_trCanadianFuelList *_poFavList;

    /* Get Capacity and Radius*/
    tU32 _u32Capacity;
    tU32 _u32Radius;
    fc_sxm_tenListMode _enTestListMode;
   /*Store All Unknown Fuel Name*/
    static vector<string> _vUnknownFuelName;
   /*Store New Fuel type Name*/
    static vector<fc_sxm_trCanadianFuelType> _vCanadianFuelTypeList;

#ifndef VARIANT_S_FTR_ENABLE_SXM_NEW_LIST_HANDLING
	/* Timer to handle List updates */
    fc_sxm_tclTimer<fc_sxm_tclCanadianFuelApp, 
        fc_sxm_trMsgListUpdateCanadianFuelTimer> _mListUpdateTimer;

#endif
};

#endif //_FC_SXM_TCL_CANADIAN_FUEL_APP_H_
