/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_wind_direction_data.h
* @brief       Declaration of handling AGW Wind Direction of Image width and height
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_WIND_DIRECTION_DATA_H_
#define _FC_SXM_TCL_AGW_WIND_DIRECTION_DATA_H_

#include "fc_sxm_tcl_agw_tiles.h"

#define FC_SXM_AGW_TILE_WIND_DIRECTION_MAX_VALUE 15
#define FC_SXM_AGW_TILE_PIXEL_OFFSET_NOT_USED 0

struct fc_sxm_tclTileProductWindDirectionData:public fc_sxm_tclTileProductBase {
public:
    fc_sxm_tclTileProductWindDirectionData():
        fc_sxm_tclTileProductBase(AGW_PRODUCT_TYPE_WIND_DIRECTION,
                                  midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPEWINDDIRECTION,
                                  midw_ext_fi_tcl_e8_SXMTileDataType::FI_EN_IMAGEPNG,
                                  "FC_SXM_WIND_DIR_DATA_Memory", 
                                  750000,
                                  10000)
    {}

	virtual tVoid vAddSpecificTileInfo(AGW_TILE_OBJECT hAgwTile, midw_ext_fi_tcl_SXMSharedMemoryTile &roFiTile);
    virtual tVoid vNotify();
};

#endif
