/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_tiles.h
* @brief       Declaration for the AGW_TILE Product
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_TILES_H_
#define _FC_SXM_TCL_AGW_TILES_H_

#include "fc_sxm_common.h"
// just take any data-fi
#include "fc_sxm_agw_fi.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_agw_app.h"
#include "fc_sxm_tcl_agw_shared_mem.h"
#include "fc_sxm_tcl_agw_products.h"


/* message received when timeout for shared memory occurs */
struct fc_sxm_trMsgAgwSharedMemTimeOut: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 1001);
    fc_sxm_trMsgAgwSharedMemTimeOut(AGW_PRODUCT_TYPE_ENUM enProductId_=AGW_PRODUCT_TYPE_UNKNOWN):
        enProductId(enProductId_)
    {}
    AGW_PRODUCT_TYPE_ENUM enProductId;
};


/*
  Base-Class for all Tile-Products
*/
class fc_sxm_tclAgwTiles;
struct fc_sxm_tclTileProductBase: public fc_sxm_tclAgwProductBase {
    public:
    fc_sxm_tclTileProductBase(AGW_PRODUCT_TYPE_ENUM enProductType_, 
                              midw_ext_fi_tcl_e8_SXMTileType::tenType enTileType_, 
                              midw_ext_fi_tcl_e8_SXMTileDataType::tenType enTileDataType_,
                              string oSharedMemName,
                              tU32 u32SharedMemSize,
                              tS32 s32SharedMemTimeOutMs_
                              );

    virtual ~fc_sxm_tclTileProductBase();

    // virtuals AgwProductBase
    virtual tVoid vNotify()=0;
    virtual tVoid vClearOutput();
    virtual tBool bIsLocked();

    // each tile has to provide its shared memory description
    midw_ext_fi_tcl_SXMSharedMemoryDescription oGetDescription();

    // entry to add a tile received from DSRL
    tVoid vAddTile(AGW_TILE_OBJECT hAgwTile);

    // hmi request data (fiResult + shared memory)
    tBool bAquire(fc_sxm_trAdressing rAdressing);

    // release of share memory
    tVoid vRelease(fc_sxm_trAdressing rAdressing=fc_sxm_trAdressing());
    
    midw_ext_fi_tcl_e8_SXMTileType::tenType enGetTileType() const {
        return enTileType;
    }

    protected:

    // if part of tile-information are product-specific, overwrite in derived class
    virtual tVoid vAddSpecificTileInfo(AGW_TILE_OBJECT hAgwTile, midw_ext_fi_tcl_SXMSharedMemoryTile &roFiTile) {

    	//to solve prio2 lint info 715
    	(tVoid)roFiTile;
    	(tVoid)hAgwTile;
    }



    midw_ext_fi_tcl_e8_SXMTileType::tenType enTileType;
    midw_ext_fi_tcl_e8_SXMTileDataType::tenType enTileDataType;

    private:
    tBool bLock();
    tVoid vUnLock();

    fc_sxm_tclSharedMem oSharedMem;
    tU32 u32SharedMemTimeOutMs;

    
    midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult oFiResult;

    fc_sxm_tclTimer<fc_sxm_tclAgwApp, fc_sxm_trMsgAgwSharedMemTimeOut, fc_sxm_tclAgwTiles> _oSharedMemTimer;

};


/*
  Declaration of Tile-Product NOWRAD
*/
#if 0
struct fc_sxm_tclTileProductNowRadData:fc_sxm_tclTileProductBase {
    fc_sxm_tclTileProductNowRadData():
        fc_sxm_tclTileProductBase(AGW_PRODUCT_TYPE_NOWRAD,
                                  midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPENOWRAD,
                                  midw_ext_fi_tcl_e8_TileDataType::FI_EN_IMAGEPNG,
                                  "FC_SXM_NOWRAD_Memory", 
                                  200000,
                                  10000)
    {}

    virtual tVoid vNotify();
};
#endif

/*
  Container-class for all tile-products
*/
class fc_sxm_tclAgwTiles:
public fc_sxm_tclSingleton<fc_sxm_tclAgwTiles>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclAgwTiles>;
    friend struct fc_sxm_tclTileProductBase;

 public:
    ~fc_sxm_tclAgwTiles();
    fc_sxm_tclTileProductBase *poGetProduct(AGW_PRODUCT_TYPE_ENUM enProductType);
    fc_sxm_tclTileProductBase *poGetProductByFiTileType(midw_ext_fi_tcl_e8_SXMTileType::tenType enTileType);
    
    tVoid vProcess(fc_sxm_trMsgAgwMStartExchangeCapabilities const *prMsg);

    tVoid vProcess(fc_sxm_trMsgAgwMStartAquireSharedMemory const *prMsg);
    tVoid vProcess(fc_sxm_trMsgAgwMStartReleaseSharedMemory const *prMsg);

    tVoid vProcessTimer(fc_sxm_trMsgAgwSharedMemTimeOut const *prMsg);
    
 private:
    fc_sxm_tclAgwTiles();
    map<AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclTileProductBase*> _mapProducts;    
    midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodResult oMRes;
    tVoid vAddProduct(fc_sxm_tclTileProductBase *poProduct);
    tVoid vRemoveProduct(fc_sxm_tclTileProductBase *poProduct);  
};


#endif
