/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_storm_attr_data.h
* @brief       Declaration of handling AGW storm product attributes
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_STORM_ATTR_DATA_H_
#define _FC_SXM_TCL_AGW_STORM_ATTR_DATA_H_

#include "fc_sxm_tcl_agw_shapes.h"
struct fc_sxm_tclShapeProductStormAttrData:public fc_sxm_tclShapeProductBase {
public:

	typedef enum {
		   enType_Tornadic,
		   enType_HailPositive,
		   enType_HailProbable,
		   enType_MesoCyclonic,
		   enType_Default
	   }tenStormAttrType;
    fc_sxm_tclShapeProductStormAttrData():
        fc_sxm_tclShapeProductBase(AGW_PRODUCT_TYPE_STORM_ATTRIBUTES)
    {};
    virtual vector<midw_ext_fi_tcl_SXMShape> &roGetShapesVector() 
    {
        return oMResStormAttrData.Shapes;
    };
    
    virtual tVoid vNotify();
    virtual tVoid vEmit(fc_sxm_trAdressing rAdressing);
	virtual tVoid vClearOutput();
        
    virtual tVoid vAddShape(AGW_SHAPE_OBJECT hAgwShape);
	// No longer used but need a dummy implementation as it is pure virtual function
	virtual tBool bAddShape(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj){
		(tVoid)hAgwShape;
		(tVoid)roShapeObj;
		return FALSE;
	}

    private:
    void vGetStormAttrbiutes(AGW_SHAPE_OBJECT hAgwShape);
    
    public:
    midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodResult oMResStormAttrData;

    private:

   struct trCompareStormAttribute {
	  
       bool operator()(midw_ext_fi_tcl_SXMShapeTypeStormAttributes const *prLeft, midw_ext_fi_tcl_SXMShapeTypeStormAttributes const *prRight) const {
           if (enGetStormAttrType(*prLeft) != enGetStormAttrType(*prRight)) {
               return enGetStormAttrType(*prLeft) < enGetStormAttrType(*prRight);
           }
           else if (prLeft->EchoTopHeight.s32Value != prRight->EchoTopHeight.s32Value) {
               return prLeft->EchoTopHeight.s32Value > prRight->EchoTopHeight.s32Value;
           }
           else {
               return prLeft->StormUniqueId < prRight->StormUniqueId;
           } 
       }
	   static tenStormAttrType enGetStormAttrType(midw_ext_fi_tcl_SXMShapeTypeStormAttributes const &stormAttr)
	   {
		   if (stormAttr.StormType.bTornadic())
			   return enType_Tornadic;
		   else if (stormAttr.StormType.bHailPositive())
			   return enType_HailPositive;
		   else if (stormAttr.StormType.bHailProbable())
			   return enType_HailProbable;
		   else if (stormAttr.StormType.bMesocyclonic())
			   return enType_MesoCyclonic;
		   else
			   return enType_Default;
	   }
   };

   
   set<midw_ext_fi_tcl_SXMShapeTypeStormAttributes*, trCompareStormAttribute> _setStormAttributes;

};

#endif
