/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_shared_mem.h
* @brief       Declaration of the AGW shared memory for sharing tile-info
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_SHARED_MEM_H_
#define _FC_SXM_TCL_AGW_SHARED_MEM_H_

#include "fc_sxm_common.h"

#include "fc_sxm_sms.h"




struct fc_sxm_tclSharedMem {
    fc_sxm_tclSharedMem(string oName, tU32 u32Size);

    ~fc_sxm_tclSharedMem();
    tU32 u32GetSize() const {
        return _u32Size;
    };

    string oGetName() const {
        return _oName;
    }
    tU32 u32Write(AGW_TILE_OBJECT hAgwTile, tU32 *pu32StartOffset);

    tVoid vInit();

    
    tVoid vDeInit();


    tVoid vReset();

    string _oName;
    tU32 _u32Size;

    OSAL_tShMemHandle _hSharedMem;
    tU8 *_pu8SharedMem;
    tU32 _u32CurOffset;

};


#endif


