/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_shapes.h
* @brief       Declaration of handling AGW Shape product
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_SHAPES_H_
#define _FC_SXM_TCL_AGW_SHAPES_H_

#include "fc_sxm_common.h"
// just take any data-fi
#include "fc_sxm_agw_fi.h"
#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_agw_products.h"


struct fc_sxm_trPoint{
    tFloat fLat;
    tFloat fLon;
};

/*
  ####### Base-Class for all shape-Products #######
*/
struct fc_sxm_tclShapeProductBase:public fc_sxm_tclAgwProductBase {
    public:
    fc_sxm_tclShapeProductBase(AGW_PRODUCT_TYPE_ENUM enProductType_);

    virtual ~fc_sxm_tclShapeProductBase();

    // virtuals AgwProductBase
    virtual tVoid vNotify()=0;
    virtual tVoid vClearOutput();

    // entry to add shape received from dsrl
    virtual tVoid vAddShape(AGW_SHAPE_OBJECT hAgwShape);
    
    // declare virtuals every shapes-product must implement
    virtual tVoid vEmit(fc_sxm_trAdressing rAdressing)=0;



    // utility to get point from a shape-object
    tU32 u32GetPoints(AGW_SHAPE_OBJECT hAgwShape, vector<fc_sxm_trPoint> &vecPoints) const;
    
    
    protected:
    // declare virtual every shapes-product must implement
    virtual vector<midw_ext_fi_tcl_SXMShape> &roGetShapesVector()=0;
    virtual tBool bAddShape(AGW_SHAPE_OBJECT hAgwShape, midw_ext_fi_tcl_SXMShape &roShapeObj)=0;
};

/*
  ####### Container-class for all shape-products #######
*/
class fc_sxm_tclAgwShapes:
public fc_sxm_tclSingleton<fc_sxm_tclAgwShapes>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclAgwShapes>;
    friend struct fc_sxm_tclShapeProductBase;

 public:
    ~fc_sxm_tclAgwShapes();
    fc_sxm_tclShapeProductBase *poGetProduct(AGW_PRODUCT_TYPE_ENUM enProductType);
    tVoid vEmit(AGW_PRODUCT_TYPE_ENUM enProductType,fc_sxm_trAdressing rAdressing);



 private:
    fc_sxm_tclAgwShapes();
    map<AGW_PRODUCT_TYPE_ENUM, fc_sxm_tclShapeProductBase*> _mapProducts;  
    tVoid vAddProduct(fc_sxm_tclShapeProductBase *poProduct);
    tVoid vRemoveProduct(fc_sxm_tclShapeProductBase *poProduct);  
    
};

#endif
