/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_properties.h
* @brief       Declaration of the AGW service properties
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef FC_SXM_TCL_AGW_PROPERTIES_H
#define FC_SXM_TCL_AGW_PROPERTIES_H

#include "fc_sxm_common.h"
#include "fc_sxm_agw_fi.h"
#include "fc_sxm_audio_fi.h"

/*
  Semaphore-protected data of agw-app
*/


// example for property, where fi-type is stored directly in member "oFiMsg"
struct fc_sxm_tcl_trAgwPropertyStormAttrDataStatus {

    bool operator!=(fc_sxm_tcl_trAgwPropertyStormAttrDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgStormAttributesDataStatus oFiMsg;
 
};


struct fc_sxm_tcl_trAgwPropertyStormTrackDataStatus {
    bool operator!=(fc_sxm_tcl_trAgwPropertyStormTrackDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgStormTrackDataStatus oFiMsg;
 
};

struct fc_sxm_tcl_trAgwPropertySurfaceDataStatus {
    bool operator!=(fc_sxm_tcl_trAgwPropertySurfaceDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgSurfaceDataStatus oFiMsg;
 
};

struct fc_sxm_tcl_trAgwPropertyNowRadDataStatus {
    bool operator!=(fc_sxm_tcl_trAgwPropertyNowRadDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgNowradDataStatus oFiMsg;
 
};

struct fc_sxm_tcl_trAgwPropertyWindDirectionDataStatus {
    bool operator!=(fc_sxm_tcl_trAgwPropertyWindDirectionDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgWindDirectionDataStatus oFiMsg;
 
};

struct fc_sxm_tcl_trAgwPropertyWindMagnitudeDataStatus {
    bool operator!=(fc_sxm_tcl_trAgwPropertyWindMagnitudeDataStatus const& b) const
    {
        return !(oFiMsg==b.oFiMsg);
    }

    midw_ext_sxm_agwfi_tclMsgWindMagnitudeDataStatus oFiMsg;
 
};


class fc_sxm_tclAgwProperties:
public fc_sxm_tclSingleton<fc_sxm_tclAgwProperties>
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclAgwProperties>;
 public:

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertyStormAttrDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_STORMATTRIBUTESDATA /* give FID if notification to service is needed  */
        > oStormAttrDataStatus;

    fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertyStormTrackDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_STORMTRACKDATA /* give FID if notification to service is needed  */
        > oStormTrackDataStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertySurfaceDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_SURFACEDATA /* give FID if notification to service is needed  */
        > oSurfaceDataStatus;
		
	fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertyNowRadDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_NOWRADDATA /* give FID if notification to service is needed  */
        > oNowRadDataStatus;
		
	fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertyWindMagnitudeDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_WINDMAGNITUDEDATA /* give FID if notification to service is needed  */
        > oWindMagnitudeDataStatus;

	fc_sxm_tclAutoProperty<fc_sxm_tcl_trAgwPropertyWindDirectionDataStatus, 
        CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, /*the service-id of the CCA-Service */
        MIDW_EXT_SXM_AGWFI_C_U16_WINDDIRECTIONDATA /* give FID if notification to service is needed  */
        > oWindDirectionDataStatus;

};

#endif
