/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_now_rad_data.cpp
* @brief       Implementation of the NOWRAD data functionalities
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#include "fc_sxm_common.h"
#include "fc_sxm_sms_util.h"
#include "fc_sxm_tcl_agw_app.h"
#include "fc_sxm_tcl_agw_now_rad_data.h"
#include "fc_sxm_service_sxm_agw.h"
#include "fc_sxm_tcl_sxmapp_manager.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_AGW_DSRL
#include "trcGenProj/Header/fc_sxm_tcl_agw_now_rad_data.cpp.trc.h"
#endif



tVoid fc_sxm_tclTileProductNowRadData::vNotify() {
    ETG_TRACE_USR4(("fc_sxm_tclTileProductNowRadData::vNotify(%d): u32UpdateCounter=%u",
                    ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType),
                    u32UpdateCounter));
    fc_sxm_tcl_trAgwPropertyNowRadDataStatus oNowRadDataStatus;
    oNowRadDataStatus.oFiMsg.UpdateCounter=u32UpdateCounter;
    fc_sxm_tclAgwProperties::instance()->oNowRadDataStatus.vSetAndNotify(oNowRadDataStatus);
}

tVoid fc_sxm_tclTileProductNowRadData::vAddSpecificTileInfo(AGW_TILE_OBJECT hAgwTile, midw_ext_fi_tcl_SXMSharedMemoryTile &roFiTile)
{
	IMAGE_OBJECT hImage;
	IMAGE_PROPERTY_VALUE_STRUCT sImageWidth, sImageHeight;
	SMSAPI_RETURN_CODE_ENUM eSmsApiReturnCode;

	ETG_TRACE_USR4(("fc_sxm_tclTileProductNowRadData::vAddSpecificTileInfo(%d)",ETG_CENUM(AGW_PRODUCT_TYPE_ENUM, enProductType)));

	//midw_ext_fi_tcl_e8_TileDataType TileDataType
	//roFiTile.TileDataType = AGW_TILE.eProductType(hAgwTile);

   //midw_ext_fi_tcl_POSIXTime IssueTime;
	roFiTile.IssueTime.Time = (tS32)(AGW_TILE.tTimeStamp(hAgwTile));
	ETG_TRACE_USR4(( "Nowrad issue time is %d", roFiTile.IssueTime.Time));
   
   //midw_ext_fi_tcl_PositionWGS84 UpperLeftCorner;
   tFloat fLat = fc_sxm_fFixed2Float(LOCATION.hLat(AGW_TILE.hNorthWest(hAgwTile)));
   tFloat fLon = fc_sxm_fFixed2Float(LOCATION.hLon(AGW_TILE.hNorthWest(hAgwTile)));
   ETG_TRACE_USR4(( "Nowrad UpperLeft Lat,Lon is %f, %f",fLat, fLon));

	roFiTile.UpperLeftCorner.Latitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(fLat);
   roFiTile.UpperLeftCorner.Longitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(fLon);

   // midw_ext_fi_tcl_PositionWGS84 LowerRightCorner;
   fLat = fc_sxm_fFixed2Float(LOCATION.hLat(AGW_TILE.hSouthEast(hAgwTile)));
   fLon = fc_sxm_fFixed2Float(LOCATION.hLon(AGW_TILE.hSouthEast(hAgwTile)));
	ETG_TRACE_USR4(( "Nowrad LowerRight Lat,Lon is %f, %f",fLat, fLon));

	roFiTile.LowerRightCorner.Latitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(fLat);
   roFiTile.LowerRightCorner.Longitude.s32Value = fc_sxm_tclHelpers::fc_sxm_s32SmsDegreeFloatToNav(fLon);

   hImage = AGW_TILE.hImage(hAgwTile);
    if (hImage == IMAGE_INVALID_OBJECT)
    {
        return;
    }

    // Gather the image properties
    eSmsApiReturnCode = IMAGE.eProperty(hImage, IMAGE_PROPERTY_HEIGHT, &sImageHeight);
    if (eSmsApiReturnCode != SMSAPI_RETURN_CODE_SUCCESS)
    {
        return;
    }
    eSmsApiReturnCode = IMAGE.eProperty(hImage, IMAGE_PROPERTY_WIDTH, &sImageWidth);
    if (eSmsApiReturnCode != SMSAPI_RETURN_CODE_SUCCESS)
    {
        return;
    }
	//tU32 Width;
	roFiTile.Width = sImageWidth.uData.un32Value;
	ETG_TRACE_USR4(( "Nowrad Tile Width is %u",roFiTile.Width));

   //tU32 Height;
	roFiTile.Height = sImageHeight.uData.un32Value;
	ETG_TRACE_USR4(( "Nowrad Tile Height is %u",roFiTile.Height));

    //tS32 PixelValueOffset;
	roFiTile.PixelValueOffset = FC_SXM_AGW_TILE_PIXEL_OFFSET_NOT_USED; //data not used for wind-direction

    // tS32 PixelValuePrecision;
	roFiTile.PixelValuePrecision = FC_SXM_AGW_TILE_PIXEL_PRECISION_NOT_USED; 

   // tU32 AddressOffset; --considered in tiles base class
   //tU32 TileSize; --considered in tiles base class

}

