/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_app.h
* @brief       Declaration of handling HMI requests and functionalities of the AGW
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/

#ifndef _FC_SXM_TCL_AGW_APP_H_
#define _FC_SXM_TCL_AGW_APP_H_

#include "fc_sxm_sms.h"
#include "fc_sxm_tcl_agw_properties.h"
#include "fc_sxm_tcl_data_app.h"

#define AGW_LATITUDE 39.828175F
#define AGW_LONGITUDE -98.5795F
#define AGW_RADIUS 3100
#define AGW_CAPACITY 1000
#define AGW_PRESSURE_VALUE_IN_PASCAL 100

class fc_sxm_tclAgwDSRL;



// method-start from cca-service
struct fc_sxm_trMsgAgwMStartGetAgwStormAttrData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 200);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart oFiMsg;

};

struct fc_sxm_trMsgAgwMStartGetAgwSurfaceData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 400);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart oFiMsg;

};

struct fc_sxm_trMsgAgwMStartGetAgwStormTrackData: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 500);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart oFiMsg;

};



struct fc_sxm_trMsgAgwMStartExchangeCapabilities: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 300);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart oFiMsg;
};

struct fc_sxm_trMsgAgwMStartAquireSharedMemory: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 1000);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart oFiMsg;
};

struct fc_sxm_trMsgAgwMStartReleaseSharedMemory: public fc_sxm_tclMessage {
    SXM_MAKE_ACTION(fc_sxm_enServiceID_AGW, 1100);
    fc_sxm_trAdressing rAdressing;
    midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart oFiMsg;
};


        


/*
  the agw-app class
*/
class fc_sxm_tclAgwApp : 
public fc_sxm_tclDataApp,
    public fc_sxm_tclSingleton<fc_sxm_tclAgwApp>
    
{
    friend class fc_sxm_tclSingleton<fc_sxm_tclAgwApp>;

 public:
    static const fc_sxm_tenServiceID _enStaticServiceId=fc_sxm_enServiceID_AGW;

    //Destructor
    virtual ~fc_sxm_tclAgwApp();


    //Initialize the agw service
    virtual tVoid vInitialize(tVoid);

    //DeInitialize the agw service
    virtual tVoid vDeInitialize(tVoid);

    // dispatch thread-messages specific for agw-app
    tVoid vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg);

    // interface to manually start reading of dsrl-entries
    tVoid vReadDsrl();

    tBool bIsDsrlReady();

 protected:
    SXM_SMS_DATASRV_ACCESS(AGW, _hAgw);
    //over ridden from data app to clear the old data during re-initialization of sms service.
    tVoid vClearServiceData(tVoid);
    // commands From CCA-Thread:
    //Start the service (Mandatory, dispatched by Base-Class)
    virtual tVoid vStartSmsService();

 private:
	// ttfis-cmds
    virtual tVoid vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg);


    // messages specific for agw-app go from here
    // fi-messages

    virtual tVoid vProcess(fc_sxm_trMsgAgwMStartGetAgwStormTrackData  const *prMsg);
    virtual tVoid vProcess(fc_sxm_trMsgAgwMStartGetAgwStormAttrData  const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgAgwMStartGetAgwSurfaceData  const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgAgwMStartAquireSharedMemory const *prMsg);
	virtual tVoid vProcess(fc_sxm_trMsgAgwMStartReleaseSharedMemory const *prMsg);
	virtual tVoid vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg);



 private:
    tVoid vCreateDSRL();

    //Constructor
    fc_sxm_tclAgwApp();

    AGW_SERVICE_OBJECT _hAgw;
	LOCATION_OBJECT _hLocation;
    DSRL_OBJECT _hDSRL;
	fc_sxm_tclAgwDSRL *_poStandardDSRL;
	tU32 updateCounter;
};

#endif //_FC_SXM_TCL_AGW_APP_H_
