/**
* @swcomponent fc_sxm
* @{
* @file        fc_sxm_tcl_agw_app.cpp
* @brief       Implementation of handling HMI requests and functionalities of the AGW
* @copyright   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
* @}
*/


#include "fc_sxm_common.h"
#include "fc_sxm_main.h"
#include "fc_sxm_tcl_sxmapp_manager.h"
#include "fc_sxm_tcl_sms_init.h"
#include "fc_sxm_service_sxm_agw.h"
#include "fc_sxm_tcl_agw_app.h"
#include "fc_sxm_tcl_agw_dsrl.h"
#include "fc_sxm_tcl_agw_shared_mem.h"
#include "fc_sxm_tcl_agw_products.h"
#include "fc_sxm_tcl_agw_shapes.h"
#include "fc_sxm_tcl_agw_tiles.h"
#if 0
#include "png.h"
#endif
typedef enum 
{
	fc_sxm_enTtfisCmdsAgw_EXCHANGE_CAPABILITIES             = 01,
    fc_sxm_enTtfisCmdsAgw_GET_STORMATTRIBUTES_DATA          = 02,
	fc_sxm_enTtfisCmdsAgw_GET_SURFACEFEATURES_DATA          = 03,
	fc_sxm_enTtfisCmdsAgw_GET_STORMTRACK_DATA               = 04,
	fc_sxm_enTtfisCmdsAgw_GET_ACQUIRE_ACCESS                = 05,
	fc_sxm_enTtfisCmdsAgw_GET_RELEASE_ACCESS				= 06
} fc_sxm_tenTtfisCmdsAgw;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SXM_AGW_APP
#include "trcGenProj/Header/fc_sxm_tcl_agw_app.cpp.trc.h"
#endif


/*
  Implementation of all callback-functions for the sms needed by agw.
  Only communication to audio-app:
  1.) Posting messages using fc_sxm_tclAgwApp::instance()->vPostMsgNew(rMsg);
  2.) writing to semaphore-protected data (fc_sxm_tclAgwProperties)
*/



/* 
   peha: constructor: give it a name and provice the used sxmServiceId (not the ccaServiceId!!)
 */
fc_sxm_tclAgwApp::fc_sxm_tclAgwApp():
    fc_sxm_tclDataApp("sxmAgwApp", _enStaticServiceId, CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER, "agw", TR_CLASS_FC_SXM_AGW_APP)
{
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp constructor"));

	_hAgw = AGW_SERVICE_INVALID_OBJECT;
    _hLocation = LOCATION_INVALID_OBJECT;
    _hDSRL = DSRL_INVALID_OBJECT;
	_poStandardDSRL=OSAL_NULL;


	updateCounter = 0;
}

/*
  Destructor
*/

fc_sxm_tclAgwApp::~fc_sxm_tclAgwApp()
{
	_hAgw = AGW_SERVICE_INVALID_OBJECT;
    _hLocation = LOCATION_INVALID_OBJECT;
    _hDSRL = DSRL_INVALID_OBJECT;
	_poStandardDSRL=OSAL_NULL;

    ETG_TRACE_USR4(("fc_sxm_tclAgwApp destructor"));
}

/* Attention: called in cca-context by sxmapp-manager */
tVoid fc_sxm_tclAgwApp::vInitialize(tVoid)
{
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vInitialize"));

    //Initialize the class members
    _hAgw = AGW_SERVICE_INVALID_OBJECT;

#if 0
    /* peha test code for inconsitent size of jmp_buf
       jira ticket has been send
       please don't remove until issue is solved
    */
    printf("peha: sizeof(jmp_buf)=%u\n", sizeof(jmp_buf));
    ETG_TRACE_USR4(("peha: sizeof(jmp_buf)=%u", sizeof(jmp_buf)));
    png_structp p_sStruct;

    printf("peha: sizeof(p_sStruct.jmp_buf)=%u\n", sizeof(p_sStruct->jmpbuf));
    ETG_TRACE_USR4(("peha: sizeof(p_sStruct.jmp_buf)=%u", sizeof(p_sStruct->jmpbuf)));

    p_sStruct = png_create_write_struct(
                                        PNG_LIBPNG_VER_STRING,
                                        NULL, NULL, NULL
                                        );
    if (p_sStruct == NULL)
    {
        ETG_TRACE_USR4(("Failed to create PNG write structure"));
    }
    png_infop p_sInfo = png_create_info_struct(p_sStruct);
    if (p_sInfo == NULL)
    {
        ETG_TRACE_USR4(("Failed to create PNG info write structure"));
    }

    png_set_longjmp_fn(p_sStruct, longjmp, sizeof (jmp_buf));

    if (setjmp(png_jmpbuf(p_sStruct)))
    {
        printf("peha: Failed during write function initialization\n");
        ETG_TRACE_USR4(("peha: Failed during write function initialization"));
    }
#endif
    //Create the agw worker thread

    /* call vInitialize of base-class to start the worker thread */
    fc_sxm_tclBaseApp::vInitialize();

    vCreateDSRL();
    // add supported products here
    fc_sxm_tclAgwProducts::instance()->vInit();
}

/* Attention: called in cca-context by sxmapp-manager */

tVoid fc_sxm_tclAgwApp::vDeInitialize(tVoid)
{
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vDeInitialize"));
    OSAL_DELETE fc_sxm_tclAgwShapes::instance();

    /* call vDeInitialize() of base-class to stop the worker thread */
    fc_sxm_tclBaseApp::vDeInitialize();

    /* Deinit of all other stuff starts from here */
}


/* 
   this method is called by the thread-function.
   For each message that shall be handled put and entry here.
*/

tVoid fc_sxm_tclAgwApp::vDispatchMsgFromQ(fc_sxm_tclMessage const *poThreadMsg)
{

   ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vDispatchMsgFromQ"));

   tU32 u32Action = poThreadMsg->u32GetAction();
   switch (u32Action)
   {
      // use macro SXM_MSGQ_DISPATCH  for each message specific for agw

      /* method-start messages from cca-service */

      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartGetAgwStormAttrData, fc_sxm_tclAgwApp::instance());
      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartGetAgwStormTrackData, fc_sxm_tclAgwApp::instance());
      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartGetAgwSurfaceData, fc_sxm_tclAgwApp::instance());

      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartExchangeCapabilities, fc_sxm_tclAgwTiles::instance());
      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartAquireSharedMemory, fc_sxm_tclAgwTiles::instance());
      SXM_MSGQ_DISPATCH_TO_OBJ(fc_sxm_trMsgAgwMStartReleaseSharedMemory, fc_sxm_tclAgwTiles::instance());

      default:
         ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vDispatchMsgFromQ(): unknown u32Action=0x%x",
                  u32Action));
         break;
   }

}

tVoid fc_sxm_tclAgwApp::vReadDsrl() {
    if (_poStandardDSRL != OSAL_NULL) {
        _poStandardDSRL->vReadDsrl();
    }
}

tBool fc_sxm_tclAgwApp::bIsDsrlReady() {
    if ((_poStandardDSRL != OSAL_NULL) &&
        (_poStandardDSRL->enGetSmsDsrlState() == DSRL_STATE_READY)) {
       return TRUE;
    }
    return FALSE;
}

/* all messages are handled via vProcess(tMsgType const *prMsg) */




/*
  handle command from sxmAppManager to start service (Mandatory)
*/
tVoid fc_sxm_tclAgwApp::vStartSmsService()
{
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp::bStartService"));

    //Check if the agw service is already started
    if (_hAgw != AGW_SERVICE_INVALID_OBJECT)
    {
        ETG_TRACE_USR4(("Agw service already started!"));
        return;
    }

   //add_raster_path --start

   BOOLEAN bDirectoryPresent, bIsSuccess;
   UN8 un8Attributes = OSAL_FILE_ATTR_READ | OSAL_FILE_ATTR_WRITE ;

   bDirectoryPresent = OSAL.bFileSystemMakeDir(TMP_FC_SXM_AGW_SMS_AGW_RASTERS_PATH);
   bIsSuccess = OSAL.bFileSystemSetFileAttributes(TMP_FC_SXM_AGW_SMS_AGW_RASTERS_PATH,un8Attributes);

   if(!bDirectoryPresent || !bIsSuccess)
   {
	   ETG_TRACE_USR4(("Agw rasters directory not created"));	   
   }


    //Start the agw service
    _hAgw = AGW.hStart(FC_SXM_SRH_DRIVER_NAME,
                         TMP_FC_SXM_AGW_SMS_AGW_RASTERS_PATH,
                         DATASERVICE_EVENT_ALL,
                         cb_vDataServiceEventCallback,
                       (tVoid*)this,
                       DATASERVICE_OPTION_NONE);

    if (_hAgw == AGW_SERVICE_INVALID_OBJECT)
    {
        ETG_TRACE_USR4(("Could not start Agw service"));
    }

}


/*
  handle command to create a dsrl (Mandatory)
*/
tVoid fc_sxm_tclAgwApp::vCreateDSRL()
{
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp::bCreateDSRL"));

	 _poStandardDSRL=OSAL_NEW fc_sxm_tclAgwDSRL(fc_sxm_enDSRLType_Standard);
	//Linit prio 2 warning fix for NULL check
	if(!_poStandardDSRL) return;
    // register DSRL
    poRegisterDsrl(_poStandardDSRL);
    
	float fLat=AGW_LATITUDE;
    float fLon=AGW_LONGITUDE;
    tS32 u32Lat=(tS32)(fLat*0xFFFF);
    tS32 u32Lon=(tS32)(fLon*0xFFFF);
    tU32 u32RadiusMiles=AGW_RADIUS;
    fc_sxm_trAgwDSRLCfg rDsrlCfg;
    rDsrlCfg.u32Capacity=AGW_CAPACITY;
    rDsrlCfg.rLocation=fc_sxm_trDsrlLocation(u32Lat, u32Lon);
	rDsrlCfg.u32Radius = u32RadiusMiles;

    rDsrlCfg.enSortMethod=fc_sxm_enAgwSortMethod_PRODUCT_TYPE;
    rDsrlCfg.rFilterCfg.enProductType=AGW_PRODUCT_TYPE_UNKNOWN;
  
	_poStandardDSRL->vSetNextConfig(rDsrlCfg);

}

tVoid fc_sxm_tclAgwApp::vProcessBaseAppMsg(fc_sxm_trMsgCmdAppTtfisCmd const *prMsg)
{
	tU8 const *au8Data=prMsg->au8Data;

	fc_sxm_tenTtfisCmdsAgw enMsgCode=(fc_sxm_tenTtfisCmdsAgw)prMsg->u8MsgCode;
    ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgCmdAppTtfisCmd) code=%d",
                    ETG_CENUM(fc_sxm_tenTtfisCmdsAgw, enMsgCode)));

    switch (enMsgCode) 
	{
		case fc_sxm_enTtfisCmdsAgw_EXCHANGE_CAPABILITIES:
        {
            midw_ext_sxm_agwfi_tclMsgExchangeCapabilitiesMethodStart oMStart;
            fc_sxm_vSendSelfMessage(oMStart);
        }
        break;
        case fc_sxm_enTtfisCmdsAgw_GET_STORMATTRIBUTES_DATA:
        {
			ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess: fc_sxm_enTtfisCmdsAgw_GET_STORMATTRIBUTES_DATA"));
            midw_ext_sxm_agwfi_tclMsgGetStormAttributesDataMethodStart oMStart;
            fc_sxm_vSendSelfMessage(oMStart);
        }
        break;
		case fc_sxm_enTtfisCmdsAgw_GET_SURFACEFEATURES_DATA:
        {
			ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess: fc_sxm_enTtfisCmdsAgw_GET_SURFACEFEATURES_DATA"));
            midw_ext_sxm_agwfi_tclMsgGetSurfaceDataMethodStart oMStart;
            fc_sxm_vSendSelfMessage(oMStart);
        }
        break;
		
		case fc_sxm_enTtfisCmdsAgw_GET_STORMTRACK_DATA:
        {
			ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess: fc_sxm_enTtfisCmdsAgw_GET_STORMTRACK_DATA"));
            midw_ext_sxm_agwfi_tclMsgGetStormTrackDataMethodStart oMStart;
            fc_sxm_vSendSelfMessage(oMStart);
        }
		break;

		case fc_sxm_enTtfisCmdsAgw_GET_ACQUIRE_ACCESS:
        {
			tU8 var = au8Data[0];
			ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess: fc_sxm_enTtfisCmdsAgw_GET_ACQUIRE_ACCESS"));

			if(1==var){			
            midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart oMStart_nowrad;
			oMStart_nowrad.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPENOWRAD;			
            fc_sxm_vSendSelfMessage(oMStart_nowrad);
			}

			if(2==var){
			midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart oMStart_windmagnitude;
			oMStart_windmagnitude.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPEWINDMAGNITUDE;
            fc_sxm_vSendSelfMessage(oMStart_windmagnitude);
			}
			
			if(3==var){
			midw_ext_sxm_agwfi_tclMsgAcquireAccessToSharedMemoryMethodStart oMStart_winddirection;
			oMStart_winddirection.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPEWINDDIRECTION;
            fc_sxm_vSendSelfMessage(oMStart_winddirection);
			}
        }
		break;

		case fc_sxm_enTtfisCmdsAgw_GET_RELEASE_ACCESS:
        {
			tU8 var = au8Data[0];
			ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess: fc_sxm_enTtfisCmdsAgw_GET_RELEASE_ACCESS"));
    
		if(1==var){
			 midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart oMStart_nowrad;
			oMStart_nowrad.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPENOWRAD;
		    fc_sxm_vSendSelfMessage(oMStart_nowrad);
		}
	
		if(2==var){			
			midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart oMStart_windmagnitude;
			oMStart_windmagnitude.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPEWINDMAGNITUDE;
            fc_sxm_vSendSelfMessage(oMStart_windmagnitude);
		}
		
		if(3==var){
			midw_ext_sxm_agwfi_tclMsgReleaseAccessFromSharedMemoryMethodStart oMStart_winddirection;
			oMStart_winddirection.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPEWINDDIRECTION;
            fc_sxm_vSendSelfMessage(oMStart_winddirection);			
		}

        }
		break;


        default:
		{
            ETG_TRACE_ERR(("fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgCmdTtfisCmd) unknown code=%d",
                           ETG_CENUM(fc_sxm_tenTtfisCmdsAgw, enMsgCode)));
		}
        break;
    }
}

/*
  Handle method-starts
*/
/*
  Method Start for Exchange Capabilities
*/
    //fc_sxm_tclSharedMem::instance()->vCCASharedMemoryListRequest(prMsg);


tVoid fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgAgwMStartGetAgwStormAttrData  const *prMsg) {
	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess for storm attributes--method start"));

    // send answer-message
    fc_sxm_tclAgwShapes::instance()->vEmit(AGW_PRODUCT_TYPE_STORM_ATTRIBUTES, prMsg->rAdressing);
}


tVoid fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgAgwMStartGetAgwStormTrackData  const *prMsg) {

	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess for storm track--method start"));

    // send answer-message
    fc_sxm_tclAgwShapes::instance()->vEmit(AGW_PRODUCT_TYPE_STORM_TRACK, prMsg->rAdressing);
}

tVoid fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgAgwMStartGetAgwSurfaceData  const *prMsg) {

	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess for surface--method start"));

    // send answer-message
    fc_sxm_tclAgwShapes::instance()->vEmit(AGW_PRODUCT_TYPE_SURFACE_FEATURES, prMsg->rAdressing);
}

tVoid fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgAgwMStartAquireSharedMemory const *prMsg) {

	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess for aquire shared memory--method start"));
	//prMsg->oFiMsg.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPENOWRAD;
    // send answer-message
    fc_sxm_tclAgwTiles::instance()->vProcess(prMsg);

}

tVoid fc_sxm_tclAgwApp::vProcess(fc_sxm_trMsgAgwMStartReleaseSharedMemory const *prMsg) {

	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess for release shared memory--method start"));
	//prMsg->oFiMsg.TileType.enType = midw_ext_fi_tcl_e8_SXMTileType::FI_EN_SXMTILETYPENOWRAD;
    // send answer-message
    fc_sxm_tclAgwTiles::instance()->vProcess(prMsg);

}


tVoid fc_sxm_tclAgwApp::vProcessGenericMsg(fc_sxm_trMsgDataSmsEvtServiceUp const *prMsg) {

	ETG_TRACE_USR4(("fc_sxm_tclAgwApp::vProcess(trMsgDataSmsEvtServiceUp)"));
	(tVoid) prMsg ;
    fc_sxm_tclAgwProducts::instance()->vSetFilters(_hAgw);


}


/****************************************************************************
*
*FUNCTION:          vClearServiceData
*
*DESCRIPTION:       To clear all the stored data during reinitialisation of SMS.
                    This is a overridden method from the data app.
*PARAMETERS:
*
*RETURNVALUES:      None
*
******************************************************************************/

tVoid fc_sxm_tclAgwApp::vClearServiceData()
{
	ETG_TRACE_USR4(("--->fc_sxm_tclAgwApp::vClearServiceData"));
	fc_sxm_tclTileProductBase *pTileProduct = fc_sxm_tclAgwTiles::instance()->poGetProduct(AGW_PRODUCT_TYPE_NOWRAD);
	pTileProduct->vClearOutput();
	ETG_TRACE_USR4(("<---fc_sxm_tclAgwApp::vClearServiceData"));

}
